/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.relvars;

import com.sleepycat.je.Transaction;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.Slot;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.TransactionRunner;
import org.reldb.rel.v0.storage.ValueRelationRelvar;
import org.reldb.rel.v0.storage.relvars.Relvar;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.relvars.RelvarMetadata;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeRelation;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarGlobalGet;
import org.reldb.rel.v0.vm.instructions.relvar.OpRelvarGlobalSet;

public abstract class RelvarGlobal
implements Slot,
Relvar {
    private RelDatabase database;
    private String name;

    public RelvarGlobal(String name, RelDatabase database) {
        this.name = name;
        this.database = database;
    }

    public String getName() {
        return this.name;
    }

    public RelDatabase getDatabase() {
        return this.database;
    }

    RelvarMetadata getRelvarMetadata() {
        try {
            return (RelvarMetadata)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    return RelvarGlobal.this.database.getRelvarMetadata(txn, RelvarGlobal.this.name);
                }
            }.execute(this.database);
        }
        catch (Throwable de) {
            throw new ExceptionFatal("RS0367: getRelvarMetadata failed: " + de);
        }
    }

    public RelvarHeading getHeadingDefinition() {
        return this.getRelvarMetadata().getHeadingDefinition(this.database);
    }

    @Override
    public Type getType() {
        return new TypeRelation(this.getHeadingDefinition().getHeading());
    }

    public ValueRelation getValue(Generator generator) {
        return new ValueRelationRelvar(generator, this);
    }

    @Override
    public void compileGet(Generator generator) {
        generator.compileInstruction(new OpRelvarGlobalGet(this.name, this.getHeadingDefinition()));
    }

    @Override
    public void compileSet(Generator generator) {
        generator.compileInstruction(new OpRelvarGlobalSet(this.name, this.getHeadingDefinition()));
    }

    @Override
    public void compileInitialise(Generator generator) {
        generator.compileInstruction(new OpRelvarGlobalSet(this.getName(), this.getHeadingDefinition()));
    }

    @Override
    public boolean isParameter() {
        return false;
    }
}

