/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.relvars;

import java.util.Vector;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.Type;

public class RelvarHeading {
    private Vector<SelectAttributes> keys = new Vector();
    private Heading heading;

    public RelvarHeading(Heading heading) {
        this.heading = heading;
    }

    public Heading getHeading() {
        return this.heading;
    }

    public String getKeyString() {
        StringBuffer outstr = new StringBuffer();
        if (this.keys.size() == 0) {
            outstr.append("KEY {ALL BUT}");
        } else {
            for (SelectAttributes attributes : this.keys) {
                outstr.append("KEY {");
                outstr.append(attributes.toString());
                outstr.append("} ");
            }
        }
        return outstr.toString().trim();
    }

    public String toString() {
        return this.getKeyString();
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public SelectAttributes getKey(int n) {
        return this.keys.get(n);
    }

    public void addKey(SelectAttributes attributes) {
        for (String attribute : attributes.getNames()) {
            if (this.heading.getIndexOf(attribute) != -1) continue;
            throw new ExceptionSemantic("RS0225: Attribute '" + attribute + "' does not exist in heading " + this.heading);
        }
        attributes.makeNamesExplicit(this.heading);
        for (SelectAttributes existingKey : this.keys) {
            if (attributes.isASubsetOf(existingKey)) {
                throw new ExceptionSemantic("RS0226: KEY {" + attributes + "} is a subset of KEY {" + existingKey + "}");
            }
            if (!existingKey.isASubsetOf(attributes)) continue;
            throw new ExceptionSemantic("RS0227: KEY {" + existingKey + "} is a subset of KEY {" + attributes + "}");
        }
        this.keys.add(attributes);
    }

    public Vector<SelectAttributes> getKeys() {
        return (Vector)this.keys.clone();
    }

    public void setKeys(Vector<SelectAttributes> keys) {
        this.keys = keys;
    }

    public boolean isKeyUsing(String attributeName) {
        if (this.keys.size() == 0) {
            return true;
        }
        for (SelectAttributes key : this.keys) {
            if (!key.getNames().contains(attributeName)) continue;
            return true;
        }
        return false;
    }

    public void renameAttribute(String oldAttributeName, String newAttributeName) {
        if (!this.heading.rename(oldAttributeName, newAttributeName)) {
            throw new ExceptionSemantic("RS0436: Attribute '" + oldAttributeName + "' not found.");
        }
        if (this.keys.size() == 0) {
            return;
        }
        for (SelectAttributes key : this.keys) {
            key.rename(oldAttributeName, newAttributeName);
        }
    }

    public void changeTypeAttribute(String attributeName, Type newType) {
        this.heading.changeTypeOfAttribute(attributeName, newType);
    }

    public void insertAttributes(Heading addHeading) {
        this.heading = this.heading.unionDisjoint(addHeading);
    }

    public void dropAttribute(String attributeName) {
        if (this.isKeyUsing(attributeName)) {
            throw new ExceptionSemantic("RS0438: Attribute '" + attributeName + "' is referenced in " + this.getKeyString() + ".");
        }
        this.heading.remove(attributeName);
    }
}

