/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.relvars;

import java.io.Serializable;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.types.Heading;

public class RelvarHeadingMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String headingText;
    private String[][] keys;

    public RelvarHeadingMetadata(RelvarHeading headingDefinition) {
        this.headingText = headingDefinition.getHeading().getSignature();
        this.keys = new String[headingDefinition.getKeyCount()][];
        int i = 0;
        while (i < this.keys.length) {
            this.keys[i] = headingDefinition.getKey(i).getNames().toArray(new String[0]);
            ++i;
        }
    }

    public RelvarHeading getHeadingDefinition(RelDatabase database) {
        Heading heading;
        Interpreter interpreter = new Interpreter(database, System.out);
        try {
            heading = interpreter.getHeading(this.headingText);
        }
        catch (ParseException pe) {
            throw new ExceptionFatal("RS0368: Failed loading heading " + this.headingText + ": " + pe.toString());
        }
        RelvarHeading relvarHeading = new RelvarHeading(heading);
        int i = 0;
        while (i < this.keys.length) {
            SelectAttributes keyAttributes = new SelectAttributes();
            int j = 0;
            while (j < this.keys[i].length) {
                keyAttributes.add(this.keys[i][j]);
                ++j;
            }
            relvarHeading.addKey(keyAttributes);
            ++i;
        }
        return relvarHeading;
    }
}

