/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.relvars;

import java.io.Serializable;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.relvars.RelvarHeadingMetadata;
import org.reldb.rel.v0.types.TypeRelation;

public abstract class RelvarMetadata
implements Serializable {
    public static final long serialVersionUID = 0L;
    private RelvarHeadingMetadata headingDefinitionMetadata;
    private transient RelvarHeading headingDefinition = null;
    private String owner;
    private long creationSequence;
    private String source;

    private void obtainSource(RelDatabase database) {
        this.source = String.valueOf(new TypeRelation(this.getHeadingDefinition(database).getHeading()).toString()) + " " + this.getHeadingDefinition(database).toString();
    }

    public RelvarMetadata(RelDatabase database, RelvarHeading headingDefinition, String owner) {
        this.headingDefinition = headingDefinition;
        this.headingDefinitionMetadata = new RelvarHeadingMetadata(headingDefinition);
        this.owner = owner;
        this.creationSequence = -1L;
        this.obtainSource(database);
    }

    public RelvarHeading getHeadingDefinition(RelDatabase database) {
        if (this.headingDefinition == null) {
            this.headingDefinition = this.headingDefinitionMetadata.getHeadingDefinition(database);
        }
        return this.headingDefinition;
    }

    public void setHeadingDefinition(RelDatabase database, RelvarHeading newHeading) {
        this.headingDefinitionMetadata = new RelvarHeadingMetadata(newHeading);
        this.headingDefinition = newHeading;
        this.obtainSource(database);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setCreationSequence(long creationSequence) {
        this.creationSequence = creationSequence;
    }

    public long getCreationSequence() {
        return this.creationSequence;
    }

    public boolean isVirtual() {
        return false;
    }

    public String getSourceDefinition() {
        return "REAL " + this.source;
    }

    public abstract RelvarGlobal getRelvar(String var1, RelDatabase var2);

    public abstract void dropRelvar(RelDatabase var1);
}

