/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.relvars;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.interpreter.Evaluation;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.relvars.RelvarVirtualMetadata;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.TypeRelation;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;

public class RelvarVirtual
extends RelvarGlobal {
    public RelvarVirtual(String name, RelDatabase database) {
        super(name, database);
    }

    @Override
    public long getCardinality(Generator generator) {
        try (TupleIterator iterator = this.iterator(generator);){
            long count = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            long l = count;
            return l;
        }
    }

    @Override
    public boolean contains(Generator generator, ValueTuple tuple) {
        try (TupleIterator iterator = this.iterator(generator);){
            while (iterator.hasNext()) {
                if (!tuple.equals(iterator.next())) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public TupleIterator iterator(Generator generator) {
        return new TupleIterator(){
            TupleIterator iterator = this.getRelationFromVirtualRelvar().iterator();

            private ValueRelation getRelationFromVirtualRelvar() {
                try {
                    RelvarVirtualMetadata metadata = (RelvarVirtualMetadata)RelvarVirtual.this.getRelvarMetadata();
                    Evaluation eval = Interpreter.evaluateExpression(RelvarVirtual.this.getDatabase(), metadata.getSourceCode(), System.out);
                    if (!(eval.getType() instanceof TypeRelation)) {
                        throw new ExceptionSemantic("RS0228: VIRTUAL relation-valued variable expected to evaluate to RELATION, but got " + eval.getType());
                    }
                    Heading evalResultHeading = ((TypeRelation)eval.getType()).getHeading();
                    if (!metadata.getHeadingDefinition(RelvarVirtual.this.getDatabase()).getHeading().canAccept(evalResultHeading)) {
                        throw new ExceptionSemantic("RS0229: VIRTUAL relation-valued variable expected to have heading of " + metadata.getHeadingDefinition(RelvarVirtual.this.getDatabase()).getHeading() + " but got " + evalResultHeading);
                    }
                    return (ValueRelation)eval.getValue();
                }
                catch (ParseException pe) {
                    throw new ExceptionSemantic("RS0230: Error in VIRTUAL relation-valued variable: " + pe.toString());
                }
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ValueTuple next() {
                return this.iterator.next();
            }

            @Override
            public void close() {
                this.iterator.close();
            }
        };
    }

    private void noUpdates() {
        throw new ExceptionSemantic("RS0231: VIRTUAL relation-valued variables are not yet updateable.");
    }

    @Override
    public void setValue(ValueRelation relation) {
        this.noUpdates();
    }

    @Override
    public long insert(Generator generator, ValueTuple tuple) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long insert(Generator generator, ValueRelation relation) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long insertNoDuplicates(Generator generator, ValueRelation relation) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public void purge() {
        this.noUpdates();
    }

    @Override
    public long delete(Context context, Operator whereTupleOperator) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long delete(Generator generator, TupleFilter filter) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long delete(Context context, ValueRelation tuplesToDelete, boolean errorIfNotIncluded) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long update(Context context, Operator updateTupleOperator) {
        this.noUpdates();
        return 0L;
    }

    @Override
    public long update(Context context, Operator whereTupleOperator, Operator updateTupleOperator) {
        this.noUpdates();
        return 0L;
    }
}

