/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.tables;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.RelTransaction;
import org.reldb.rel.v0.values.TupleIterator;

public abstract class RegisteredTupleIterator
extends TupleIterator
implements Comparable<RegisteredTupleIterator> {
    private static long iteratorIDGenerator = 0L;
    private Long iteratorID = iteratorIDGenerator++;
    private RelDatabase database;
    protected Cursor cursor;
    protected RelTransaction txn = null;

    public RegisteredTupleIterator(RelDatabase database) {
        this.database = database;
        database.registerTupleIterator(this);
    }

    public int hashCode() {
        return this.iteratorID.hashCode();
    }

    @Override
    public int compareTo(RegisteredTupleIterator iterator) {
        return this.iteratorID.compareTo(this.iteratorID);
    }

    public boolean forceClose() {
        try {
            if (this.cursor != null) {
                this.cursor.close();
                this.database.commitTransaction(this.txn);
                return true;
            }
            return false;
        }
        catch (DatabaseException exp) {
            exp.printStackTrace();
            throw new ExceptionFatal("RS0378: Unable to close cursor: " + exp.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.forceClose();
        }
        finally {
            this.database.unregisterTupleIterator(this);
        }
    }
}

