/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.tables;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.TransactionRunner;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.storage.tables.RegisteredTupleIterator;
import org.reldb.rel.v0.storage.tables.Storage;
import org.reldb.rel.v0.storage.temporary.TempTableImplementation;
import org.reldb.rel.v0.types.AttributeMap;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.TupleMap;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.VirtualMachine;

public abstract class Table {
    private RelDatabase database;
    private RelvarHeading headingDefinition;
    private AttributeMap[] keyMaps;

    public Table(RelDatabase database, RelvarHeading headingDefinition) {
        this.database = database;
        this.headingDefinition = headingDefinition;
        this.keyMaps = new AttributeMap[headingDefinition.getKeyCount()];
        int keyNumber = 0;
        while (keyNumber < headingDefinition.getKeyCount()) {
            SelectAttributes keyAttributes = headingDefinition.getKey(keyNumber);
            Heading sourceHeading = headingDefinition.getHeading();
            Heading targetHeading = sourceHeading.project(keyAttributes);
            this.keyMaps[keyNumber] = new AttributeMap(targetHeading, sourceHeading);
            ++keyNumber;
        }
    }

    public RelvarHeading getHeadingDefinition() {
        return this.headingDefinition;
    }

    protected abstract Storage getStorage(Transaction var1) throws DatabaseException;

    public RelDatabase getDatabase() {
        return this.database;
    }

    private DatabaseEntry getKeyValueFromTuple(Generator generator, ValueTuple tuple, int keyNumber) {
        DatabaseEntry theKey = new DatabaseEntry();
        if (this.headingDefinition.getKeyCount() == 0) {
            this.database.getTupleBinding().objectToEntry((Object)tuple, theKey);
        } else {
            ValueTuple keyTuple = this.keyMaps[keyNumber].project(generator, tuple);
            this.database.getTupleBinding().objectToEntry((Object)keyTuple, theKey);
        }
        return theKey;
    }

    public boolean insertTupleNoDuplicates(Generator generator, Storage table, Transaction txn, ValueTuple tuple, String description) throws DatabaseException {
        DatabaseEntry theData = new DatabaseEntry();
        this.database.getTupleBinding().objectToEntry((Object)tuple, theData);
        int i = 0;
        while (i < table.size()) {
            DatabaseEntry entry;
            Database tab = table.getDatabase(i);
            DatabaseEntry databaseEntry = entry = i == 0 ? theData : this.database.getKeyTableEntry();
            if (tab.putNoOverwrite(txn, this.getKeyValueFromTuple(generator, tuple, i), entry) == OperationStatus.KEYEXIST) {
                throw new ExceptionSemantic("RS0232: " + description + " tuple would violate uniqueness constraint of KEY {" + this.headingDefinition.getKey(i) + "}");
            }
            ++i;
        }
        return true;
    }

    boolean insertTuple(Generator generator, Storage table, Transaction txn, ValueTuple tuple, String description) throws DatabaseException {
        DatabaseEntry theData = new DatabaseEntry();
        this.database.getTupleBinding().objectToEntry((Object)tuple, theData);
        int i = 0;
        while (i < table.size()) {
            DatabaseEntry entry;
            Database tab = table.getDatabase(i);
            DatabaseEntry databaseEntry = entry = i == 0 ? theData : this.database.getKeyTableEntry();
            if (tab.putNoOverwrite(txn, this.getKeyValueFromTuple(generator, tuple, i), entry) == OperationStatus.KEYEXIST) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void insert(final Generator generator, final ValueTuple tuple) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Table.this.insertTupleNoDuplicates(generator, Table.this.getStorage(txn), txn, (ValueTuple)tuple.getSerializableClone(), "Inserting");
                    return null;
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            throw new ExceptionSemantic("RS0233: insert tuple failed: " + t.getMessage());
        }
    }

    private long insert(final Generator generator, final ValueRelation relation, final Inserter inserter) {
        try {
            return (Long)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    long insertCount = 0L;
                    try (TempTableImplementation tmp = new TempTableImplementation(Table.this.database);){
                        ValueTuple tuple;
                        Storage table = Table.this.getStorage(txn);
                        try (TupleIterator iterator = relation.iterator();){
                            while (iterator.hasNext()) {
                                tuple = (ValueTuple)iterator.next().getSerializableClone();
                                tmp.put(tuple);
                            }
                        }
                        iterator = tmp.values();
                        try {
                            while (iterator.hasNext()) {
                                tuple = iterator.next();
                                if (!inserter.insert(generator, table, txn, tuple, "Inserting")) continue;
                                ++insertCount;
                            }
                        }
                        finally {
                            iterator.close();
                        }
                    }
                    return new Long(insertCount);
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionSemantic("RS0234: insert relation failed: " + t.getMessage());
        }
    }

    public long insert(Generator generator, ValueRelation relation) {
        return this.insert(generator, relation, new Inserter(){

            @Override
            boolean insert(Generator generator, Storage table, Transaction txn, ValueTuple tuple, String comment) {
                return Table.this.insertTuple(generator, table, txn, tuple, comment);
            }
        });
    }

    public long insertNoDuplicates(Generator generator, ValueRelation relation) {
        return this.insert(generator, relation, new Inserter(){

            @Override
            boolean insert(Generator generator, Storage table, Transaction txn, ValueTuple tuple, String comment) {
                return Table.this.insertTupleNoDuplicates(generator, table, txn, tuple, comment);
            }
        });
    }

    public long getCardinality() {
        try {
            return (Long)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    return new Long(Table.this.getStorage(txn).getDatabase(0).count());
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable de) {
            de.printStackTrace();
            throw new ExceptionFatal("RS0370: getCardinality failed: " + de.getMessage());
        }
    }

    public ValueTuple getTupleForKey(final Generator generator, final ValueTuple tuple) {
        try {
            return (ValueTuple)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    DatabaseEntry foundData = new DatabaseEntry();
                    if (Table.this.getStorage(txn).getDatabase(0).get(txn, Table.this.getKeyValueFromTuple(generator, tuple, 0), foundData, LockMode.READ_COMMITTED) == OperationStatus.SUCCESS) {
                        return (ValueTuple)Table.this.database.getTupleBinding().entryToObject(foundData);
                    }
                    return null;
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0371: getTupleForKey failed: " + t.getMessage());
        }
    }

    public boolean contains(final Generator generator, final ValueTuple tuple) {
        try {
            return (Boolean)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    DatabaseEntry foundData = new DatabaseEntry();
                    DatabaseEntry keyData = Table.this.getKeyValueFromTuple(generator, tuple, 0);
                    return Table.this.getStorage(txn).getDatabase(0).get(txn, keyData, foundData, LockMode.READ_COMMITTED) == OperationStatus.SUCCESS;
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0372: contains failed: " + t.getMessage());
        }
    }

    private void purge(Transaction txn) throws DatabaseException {
        Storage tables = this.getStorage(txn);
        int i = 0;
        while (i < tables.size()) {
            try (Cursor cursor = tables.getDatabase(i).openCursor(txn, null);){
                DatabaseEntry foundKey = new DatabaseEntry();
                DatabaseEntry foundData = new DatabaseEntry();
                while (cursor.getNext(foundKey, foundData, LockMode.RMW) == OperationStatus.SUCCESS) {
                    cursor.delete();
                }
            }
            ++i;
        }
    }

    public void purge() {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Table.this.purge(txn);
                    return null;
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0373: purge failed: " + t.getMessage());
        }
    }

    public void delete(final Generator generator, final ValueTuple tuple) {
        try {
            new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Storage tables = Table.this.getStorage(txn);
                    int i = 0;
                    while (i < tables.size()) {
                        tables.getDatabase(i).delete(txn, Table.this.getKeyValueFromTuple(generator, tuple, i));
                        ++i;
                    }
                    return null;
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0374: delete tuple failed: " + t.getMessage());
        }
    }

    public long delete(final Generator generator, final TupleFilter filter) {
        try {
            return (Long)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    Storage tables = Table.this.getStorage(txn);
                    long deleteCount = 0L;
                    try (Cursor cursor = tables.getDatabase(0).openCursor(txn, null);){
                        DatabaseEntry foundKey = new DatabaseEntry();
                        DatabaseEntry foundData = new DatabaseEntry();
                        while (cursor.getNext(foundKey, foundData, LockMode.RMW) == OperationStatus.SUCCESS) {
                            ValueTuple tuple = (ValueTuple)Table.this.database.getTupleBinding().entryToObject(foundData);
                            tuple.loaded(generator);
                            if (!filter.filter(tuple)) continue;
                            cursor.delete();
                            int i = 1;
                            while (i < tables.size()) {
                                tables.getDatabase(i).delete(txn, Table.this.getKeyValueFromTuple(generator, tuple, i));
                                ++i;
                            }
                            ++deleteCount;
                        }
                    }
                    return new Long(deleteCount);
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0375: delete tuples failed: " + t.getMessage());
        }
    }

    public long delete(Context context, ValueRelation tuplesToDelete, boolean errorIfNotIncluded) {
        final HashMap<ValueTuple, Boolean> toDelete = new HashMap<ValueTuple, Boolean>();
        Generator generator = context.getGenerator();
        try (TupleIterator iterator = tuplesToDelete.iterator();){
            while (iterator.hasNext()) {
                toDelete.put(iterator.next(), Boolean.FALSE);
            }
        }
        if (errorIfNotIncluded) {
            try (TupleIterator relvarTupleIterator = this.iterator(generator);){
                while (relvarTupleIterator.hasNext()) {
                    ValueTuple keyTuple = relvarTupleIterator.next();
                    if (!toDelete.containsKey(keyTuple)) continue;
                    toDelete.put(keyTuple, Boolean.TRUE);
                }
            }
            Collection values = toDelete.values();
            Iterator valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                if (((Boolean)valueIterator.next()).booleanValue()) continue;
                throw new ExceptionSemantic("RS0235: In I_DELETE, one or more specified tuples are not included in the relvar.");
            }
        }
        return this.delete(generator, new TupleFilter(){

            @Override
            public boolean filter(ValueTuple tuple) {
                return toDelete.containsKey(tuple);
            }
        });
    }

    public long update(final Generator generator, final TupleFilter whereFilter, final TupleMap updateMap) {
        try {
            return (Long)new TransactionRunner(){

                @Override
                public Object run(Transaction txn) throws Throwable {
                    long updateCount = 0L;
                    try (TempTableImplementation insertionTemporaryTable = new TempTableImplementation(Table.this.database);){
                        Storage tables = Table.this.getStorage(txn);
                        DatabaseEntry foundKey = new DatabaseEntry();
                        DatabaseEntry foundData = new DatabaseEntry();
                        try (Cursor cursor = tables.getDatabase(0).openCursor(txn, null);){
                            while (cursor.getNext(foundKey, foundData, LockMode.RMW) == OperationStatus.SUCCESS) {
                                ValueTuple tuple = (ValueTuple)Table.this.database.getTupleBinding().entryToObject(foundData);
                                tuple.loaded(generator);
                                if (!whereFilter.filter(tuple)) continue;
                                ValueTuple newTuple = updateMap.map(tuple);
                                cursor.delete();
                                int i = 1;
                                while (i < tables.size()) {
                                    tables.getDatabase(i).delete(txn, Table.this.getKeyValueFromTuple(generator, tuple, i));
                                    ++i;
                                }
                                ValueTuple data = (ValueTuple)newTuple.getSerializableClone();
                                insertionTemporaryTable.put(data);
                                ++updateCount;
                            }
                        }
                        try (TupleIterator iterator = insertionTemporaryTable.values();){
                            while (iterator.hasNext()) {
                                Table.this.insertTupleNoDuplicates(generator, tables, txn, iterator.next(), "Updating");
                            }
                        }
                    }
                    return new Long(updateCount);
                }
            }.execute(this.database);
        }
        catch (ExceptionSemantic se) {
            throw se;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ExceptionFatal("RS0376: update failed: " + t.getMessage());
        }
    }

    public long update(Generator generator, TupleMap map) {
        return this.update(generator, new TupleFilter(){

            @Override
            public boolean filter(ValueTuple tuple) {
                return true;
            }
        }, map);
    }

    public TupleIterator iterator(final Generator generator) {
        return new RegisteredTupleIterator(this.database){
            DatabaseEntry foundKey;
            DatabaseEntry foundData;
            ValueTuple current;
            boolean atEnd;
            {
                super($anonymous0);
                this.foundKey = new DatabaseEntry();
                this.foundData = new DatabaseEntry();
                this.current = null;
                this.atEnd = false;
            }

            @Override
            public boolean hasNext() {
                block6: {
                    if (this.current != null) {
                        return true;
                    }
                    if (this.atEnd) {
                        return false;
                    }
                    try {
                        if (this.cursor == null) {
                            this.txn = Table.this.database.beginTransaction();
                            this.cursor = Table.this.getStorage(this.txn.getTransaction()).getDatabase(0).openCursor(this.txn.getTransaction(), null);
                        }
                        if (this.cursor.getNext(this.foundKey, this.foundData, LockMode.DEFAULT) != OperationStatus.SUCCESS) break block6;
                        this.current = (ValueTuple)Table.this.database.getTupleBinding().entryToObject(this.foundData);
                        this.current.loaded(generator);
                        return true;
                    }
                    catch (DatabaseException exp) {
                        exp.printStackTrace();
                        throw new ExceptionFatal("RS0377: Unable to get next tuple: " + exp.getMessage());
                    }
                }
                this.atEnd = true;
                return false;
            }

            @Override
            public ValueTuple next() {
                if (this.hasNext()) {
                    try {
                        ValueTuple valueTuple = this.current;
                        return valueTuple;
                    }
                    finally {
                        this.current = null;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    public void expandTuples(Transaction txn, ValueTuple rightTuple) {
        Storage tables = this.getStorage(txn);
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        try (Cursor cursor = tables.getDatabase(0).openCursor(txn, null);){
            while (cursor.getNext(foundKey, foundData, LockMode.RMW) == OperationStatus.SUCCESS) {
                ValueTuple oldTuple = (ValueTuple)this.database.getTupleBinding().entryToObject(foundData);
                ValueTuple newTuple = oldTuple.joinDisjoint(rightTuple);
                DatabaseEntry theData = new DatabaseEntry();
                this.database.getTupleBinding().objectToEntry((Object)newTuple, theData);
                cursor.putCurrent(theData);
            }
        }
    }

    public void shrinkTuples(Transaction txn, int attributeIndex) {
        Storage tables = this.getStorage(txn);
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        try (Cursor cursor = tables.getDatabase(0).openCursor(txn, null);){
            while (cursor.getNext(foundKey, foundData, LockMode.RMW) == OperationStatus.SUCCESS) {
                ValueTuple oldTuple = (ValueTuple)this.database.getTupleBinding().entryToObject(foundData);
                ValueTuple newTuple = oldTuple.shrink(attributeIndex);
                DatabaseEntry theData = new DatabaseEntry();
                this.database.getTupleBinding().objectToEntry((Object)newTuple, theData);
                cursor.putCurrent(theData);
            }
        }
    }

    public void convertTuples(Generator generator, Transaction txn, Type oldType, int oldAttributeIndex, int newAttributeIndex, Instruction selector) {
        Storage tables = this.getStorage(txn);
        DatabaseEntry foundKey = new DatabaseEntry();
        DatabaseEntry foundData = new DatabaseEntry();
        Cursor cursor = tables.getDatabase(0).openCursor(txn, null);
        VirtualMachine vm = new VirtualMachine(generator, this.database, System.out);
        Context context = new Context(generator, vm);
        try {
            while (cursor.getNext(foundKey, foundData, LockMode.RMW) == OperationStatus.SUCCESS) {
                Value newValue;
                ValueTuple oldTuple = (ValueTuple)this.database.getTupleBinding().entryToObject(foundData);
                ValueCharacter oldValue = ValueCharacter.select(generator, oldTuple.getValues()[oldAttributeIndex].toParsableString(oldType));
                context.push(oldValue);
                selector.execute(context);
                oldTuple.getValues()[newAttributeIndex] = newValue = context.pop();
                DatabaseEntry theData = new DatabaseEntry();
                this.database.getTupleBinding().objectToEntry((Object)oldTuple, theData);
                cursor.putCurrent(theData);
            }
        }
        finally {
            cursor.close();
        }
    }

    private static abstract class Inserter {
        private Inserter() {
        }

        abstract boolean insert(Generator var1, Storage var2, Transaction var3, ValueTuple var4, String var5);
    }
}

