/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.temporary;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.NoSuchElementException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.temporary.TempIndex;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueTuple;

class TempIndexDisk
implements TempIndex {
    private Database keys;
    private Database values;
    private RelDatabase database;
    private Long id = 0L;

    public TempIndexDisk(RelDatabase db) {
        this.database = db;
        this.keys = this.database.createTempStorage();
        this.values = this.database.createTempStorageWithDuplicatesNoComparator();
    }

    @Override
    public void close() {
        this.database.destroyTempStorage(this.keys);
        this.database.destroyTempStorage(this.values);
    }

    @Override
    public void put(ValueTuple keyTuple, ValueTuple valueTuple) throws DatabaseException {
        DatabaseEntry theKey = new DatabaseEntry();
        this.database.getTupleBinding().objectToEntry((Object)keyTuple, theKey);
        DatabaseEntry theID = new DatabaseEntry();
        OperationStatus status = this.keys.get(null, theKey, theID, LockMode.DEFAULT);
        if (status == OperationStatus.NOTFOUND) {
            Long l = this.id;
            this.id = l + 1L;
            LongBinding.longToEntry((long)l, (DatabaseEntry)theID);
            this.keys.put(null, theKey, theID);
        } else if (status != OperationStatus.SUCCESS) {
            throw new ExceptionFatal("RS0318: Insertion failure in put().");
        }
        DatabaseEntry theData = new DatabaseEntry();
        this.database.getTupleBinding().objectToEntry((Object)valueTuple, theData);
        this.values.put(null, theID, theData);
    }

    @Override
    public TupleIterator keySearch(ValueTuple keyTuple) {
        DatabaseEntry theKey = new DatabaseEntry();
        this.database.getTupleBinding().objectToEntry((Object)keyTuple, theKey);
        final DatabaseEntry theID = new DatabaseEntry();
        OperationStatus status = this.keys.get(null, theKey, theID, LockMode.DEFAULT);
        if (status == OperationStatus.SUCCESS) {
            return new TupleIterator(){
                protected Cursor cursor = null;
                protected ValueTuple current = null;

                @Override
                public ValueTuple next() {
                    if (this.hasNext()) {
                        try {
                            ValueTuple valueTuple = this.current;
                            return valueTuple;
                        }
                        finally {
                            this.current = null;
                        }
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void close() {
                    try {
                        if (this.cursor != null) {
                            this.cursor.close();
                        }
                    }
                    catch (DatabaseException exp) {
                        throw new ExceptionFatal("RS0319: Unable to close cursor: " + exp.getMessage());
                    }
                }

                @Override
                public boolean hasNext() {
                    DatabaseEntry foundData;
                    block6: {
                        if (this.current != null) {
                            return true;
                        }
                        try {
                            foundData = new DatabaseEntry();
                            if (this.cursor != null) break block6;
                            this.cursor = TempIndexDisk.this.values.openCursor(null, null);
                            if (this.cursor.getSearchKey(theID, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                                this.current = (ValueTuple)TempIndexDisk.this.database.getTupleBinding().entryToObject(foundData);
                                return true;
                            }
                            return false;
                        }
                        catch (DatabaseException exp) {
                            throw new ExceptionFatal("RS0320: Unable to get next tuple: " + exp.getMessage());
                        }
                    }
                    if (this.cursor.getNextDup(theID, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                        this.current = (ValueTuple)TempIndexDisk.this.database.getTupleBinding().entryToObject(foundData);
                        return true;
                    }
                    return false;
                }
            };
        }
        return new TupleIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public ValueTuple next() {
                return null;
            }

            @Override
            public void close() {
            }
        };
    }
}

