/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.temporary;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.temporary.TempIndex;
import org.reldb.rel.v0.storage.temporary.TempIndexDisk;
import org.reldb.rel.v0.storage.temporary.TempIndexMemory;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueTuple;

public class TempIndexImplementation
implements TempIndex {
    private static final long storageMemoryLimit = 100L;
    private TempIndex storageImplementation;
    private long storageCount = 0L;
    private RelDatabase database;

    public TempIndexImplementation(RelDatabase db) {
        this.database = db;
        this.storageImplementation = new TempIndexMemory();
    }

    @Override
    public void close() {
        this.storageImplementation.close();
    }

    @Override
    public void put(ValueTuple keyTuple, ValueTuple valueTuple) {
        this.storageImplementation.put(keyTuple, valueTuple);
        ++this.storageCount;
        if (this.storageCount == 100L) {
            TempIndexDisk target = new TempIndexDisk(this.database);
            Iterator<Map.Entry<ValueTuple, LinkedList<ValueTuple>>> source = ((TempIndexMemory)this.storageImplementation).iterator();
            while (source.hasNext()) {
                Map.Entry<ValueTuple, LinkedList<ValueTuple>> entry = source.next();
                LinkedList<ValueTuple> values = entry.getValue();
                Iterator valueIterator = values.iterator();
                while (valueIterator.hasNext()) {
                    target.put(entry.getKey(), (ValueTuple)valueIterator.next());
                }
            }
            this.storageImplementation.close();
            this.storageImplementation = target;
        }
    }

    @Override
    public TupleIterator keySearch(ValueTuple key) {
        return this.storageImplementation.keySearch(key);
    }
}

