/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.temporary;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.NoSuchElementException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.temporary.TempTable;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueTuple;

class TempTableDisk
implements TempTable {
    private Database storage;
    private RelDatabase database;

    public TempTableDisk(RelDatabase db) {
        this.database = db;
        this.storage = this.database.createTempStorage();
    }

    @Override
    public void close() {
        this.database.destroyTempStorage(this.storage);
    }

    @Override
    public void put(ValueTuple tuple) throws DatabaseException {
        DatabaseEntry theKey = new DatabaseEntry();
        this.database.getTupleBinding().objectToEntry((Object)tuple, theKey);
        this.storage.put(null, theKey, this.database.getKeyTableEntry());
    }

    @Override
    public TupleIterator values() {
        return new StorageIterator();
    }

    private class StorageIterator
    extends TupleIterator {
        protected Cursor cursor = null;
        protected ValueTuple current = null;

        private StorageIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.current != null) {
                return true;
            }
            try {
                DatabaseEntry foundData;
                DatabaseEntry foundKey;
                if (this.cursor == null) {
                    this.cursor = TempTableDisk.this.storage.openCursor(null, null);
                }
                if (this.cursor.getNext(foundKey = new DatabaseEntry(), foundData = new DatabaseEntry(), LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    this.current = (ValueTuple)TempTableDisk.this.database.getTupleBinding().entryToObject(foundKey);
                    return true;
                }
            }
            catch (DatabaseException exp) {
                throw new ExceptionFatal("RS0321: Unable to get next tuple: " + exp.getMessage());
            }
            return false;
        }

        @Override
        public ValueTuple next() {
            if (this.hasNext()) {
                try {
                    ValueTuple valueTuple = this.current;
                    return valueTuple;
                }
                finally {
                    this.current = null;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
            try {
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
            catch (DatabaseException exp) {
                throw new ExceptionFatal("RS0322: Unable to close cursor: " + exp.getMessage());
            }
        }
    }
}

