/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.storage.temporary;

import java.util.Iterator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.temporary.TempTable;
import org.reldb.rel.v0.storage.temporary.TempTableDisk;
import org.reldb.rel.v0.storage.temporary.TempTableMemory;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueTuple;

public class TempTableImplementation
implements TempTable {
    private static final long storageMemoryLimit = 100L;
    private TempTable storageImplementation;
    private long storageCount = 0L;
    private RelDatabase database;

    public TempTableImplementation(RelDatabase db) {
        this.database = db;
        this.storageImplementation = new TempTableMemory();
    }

    @Override
    public void close() {
        this.storageImplementation.close();
    }

    @Override
    public void put(ValueTuple dataTuple) {
        this.storageImplementation.put(dataTuple);
        ++this.storageCount;
        if (this.storageCount == 100L) {
            TempTableDisk target = new TempTableDisk(this.database);
            Iterator<ValueTuple> source = ((TempTableMemory)this.storageImplementation).iterator();
            while (source.hasNext()) {
                target.put(source.next());
            }
            this.storageImplementation.close();
            this.storageImplementation = target;
        }
    }

    @Override
    public TupleIterator values() {
        return this.storageImplementation.values();
    }
}

