/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import java.io.Serializable;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Attribute;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.TypeHeading;
import org.reldb.rel.v0.values.Projectable;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueTuple;

public class AttributeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] map;
    private AttributeMap[] nestmap;

    public AttributeMap(Heading to, Heading from) {
        this.map = new int[to.getDegree()];
        this.nestmap = new AttributeMap[to.getDegree()];
        int toAttributeIndex = 0;
        for (Attribute attribute : to.getAttributes()) {
            int attributeIndex = from.getIndexOf(attribute.getName());
            if (attributeIndex < 0) {
                throw new ExceptionSemantic("RS0240: Attribute " + attribute.getName() + " not found in " + from);
            }
            Attribute fromAttribute = from.getAttributes().get(attributeIndex);
            if (!attribute.getType().canAccept(fromAttribute.getType())) {
                throw new ExceptionSemantic("RS0241: Attribute " + attribute.getName() + " mismatch between " + attribute.getType() + " and " + fromAttribute.getType());
            }
            if (attribute.getType().requiresReformatOf(fromAttribute.getType())) {
                this.nestmap[toAttributeIndex] = new AttributeMap(((TypeHeading)attribute.getType()).getHeading(), ((TypeHeading)fromAttribute.getType()).getHeading());
            }
            this.map[toAttributeIndex++] = attributeIndex;
        }
    }

    public void assign(Value[] values, ValueTuple from) {
        Value[] source = from.getValues();
        int i = 0;
        while (i < this.map.length) {
            values[this.map[i]] = this.nestmap[i] != null ? ((Projectable)((Object)source[i])).project(this.nestmap[i]) : source[i];
            ++i;
        }
    }

    public ValueTuple project(Generator generator, ValueTuple from) {
        Value[] source = from.getValues();
        Value[] target = new Value[this.map.length];
        int i = 0;
        while (i < target.length) {
            target[i] = this.nestmap[i] != null ? ((Projectable)((Object)source[this.map[i]])).project(this.nestmap[i]) : source[this.map[i]];
            ++i;
        }
        return new ValueTuple(generator, target);
    }

    public String toString() {
        String out = null;
        int i = 0;
        while (i < this.map.length) {
            out = this.nestmap[i] == null ? String.valueOf(out == null ? "" : String.valueOf(out) + ", ") + i + "=" + this.map[i] : String.valueOf(out == null ? "" : String.valueOf(out) + ", ") + i + "=" + this.map[i] + " (" + this.nestmap[i] + ")";
            ++i;
        }
        return "AttributeMap [" + (out == null ? "" : out) + "]";
    }
}

