/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import java.util.UUID;
import java.util.Vector;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.SelectAttributes;
import org.reldb.rel.v0.types.Attribute;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.TypeRelation;
import org.reldb.rel.v0.types.TypeTuple;

public class Heading
implements Comparable<Heading> {
    private Vector<Attribute> attributes = new Vector();

    public Heading() {
    }

    Heading(Heading oldHeading) {
        this.attributes.addAll(oldHeading.getAttributes());
    }

    public Heading(TypeTuple tupleType) {
        this(tupleType.getHeading());
    }

    public Heading(TypeRelation relationType) {
        this(relationType.getHeading());
    }

    public Heading unionDisjoint(Heading rightHeading) {
        Heading joinedHeading = new Heading(this);
        for (Attribute rightAttribute : rightHeading.attributes) {
            if (this.getIndexOf(rightAttribute.getName()) >= 0) {
                throw new ExceptionSemantic("RS0242: Attribute '" + rightAttribute.getName() + "' is found in both operands.");
            }
            joinedHeading.attributes.add(rightAttribute);
        }
        return joinedHeading;
    }

    public Heading union(Heading rightHeading) {
        Heading joinedHeading = new Heading(this);
        for (Attribute rightAttribute : rightHeading.attributes) {
            Attribute leftAttribute = this.getAttribute(rightAttribute.getName());
            if (leftAttribute != null) {
                if (leftAttribute.getType().canAccept(rightAttribute.getType())) continue;
                throw new ExceptionSemantic("RS0243: An attribute named '" + rightAttribute.getName() + "' is found in both operands but differs in type.");
            }
            joinedHeading.attributes.add(rightAttribute);
        }
        return joinedHeading;
    }

    public Heading intersect(Heading rightHeading) {
        Heading intersectedHeading = new Heading();
        for (Attribute leftAttribute : this.attributes) {
            Attribute rightAttribute = rightHeading.getAttribute(leftAttribute.getName());
            if (rightAttribute == null) continue;
            if (!leftAttribute.getType().canAccept(rightAttribute.getType())) {
                throw new ExceptionSemantic("RS0244: An attribute named '" + rightAttribute.getName() + "' is found in both operands but differs in type.");
            }
            intersectedHeading.attributes.add(rightAttribute);
        }
        return intersectedHeading;
    }

    public Heading minus(Heading rightHeading) {
        Heading minusHeading = new Heading();
        for (Attribute leftAttribute : this.attributes) {
            Attribute rightAttribute = rightHeading.getAttribute(leftAttribute.getName());
            if (rightAttribute == null) {
                minusHeading.attributes.add(leftAttribute);
                continue;
            }
            if (leftAttribute.getType().canAccept(rightAttribute.getType())) continue;
            throw new ExceptionSemantic("RS0245: An attribute named '" + rightAttribute.getName() + "' is found in both operands but differs in type.");
        }
        return minusHeading;
    }

    public Heading project(SelectAttributes selection) {
        Heading heading;
        if (selection.isAllBut()) {
            heading = new Heading(this);
            for (String name : selection.getNames()) {
                heading.remove(name);
            }
        } else {
            heading = new Heading();
            for (String name : selection.getNames()) {
                Attribute attribute = this.getAttribute(name);
                if (attribute == null) {
                    throw new ExceptionSemantic("RS0246: Attribute '" + name + "' not found.");
                }
                heading.attributes.add(attribute);
            }
        }
        return heading;
    }

    public void remove(String name) {
        int index = this.getIndexOf(name);
        if (index < 0) {
            throw new ExceptionSemantic("RS0247: Attribute '" + name + "' not found.");
        }
        this.attributes.remove(index);
    }

    private void rename(Attribute oldAttribute, String newName) {
        int index = this.getIndexOf(oldAttribute.getName());
        if (index == -1) {
            throw new ExceptionSemantic("RS0248: Attribute '" + oldAttribute.getName() + "' not found.");
        }
        if (this.getAttribute(newName) != null) {
            throw new ExceptionSemantic("RS0249: Attribute '" + newName + "' has already been defined.");
        }
        this.attributes.set(index, new Attribute(newName, oldAttribute.getType()));
    }

    public boolean rename(String from, String to) {
        Attribute oldAttribute = this.getAttribute(from);
        if (oldAttribute == null) {
            return false;
        }
        this.rename(oldAttribute, to);
        return true;
    }

    public boolean renamePrefix(String from, String to) {
        boolean renamed = false;
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().startsWith(from)) continue;
            this.rename(attribute, String.valueOf(to) + attribute.getName().substring(from.length()));
            renamed = true;
        }
        return renamed;
    }

    public boolean renameSuffix(String from, String to) {
        boolean renamed = false;
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().endsWith(from)) continue;
            this.rename(attribute, String.valueOf(attribute.getName().substring(0, attribute.getName().length() - from.length())) + to);
            renamed = true;
        }
        return renamed;
    }

    public void add(String attributeName, Type attributeType) {
        if (this.getAttribute(attributeName) != null) {
            throw new ExceptionSemantic("RS0250: Attribute '" + attributeName + "' has already been defined.");
        }
        this.attributes.add(new Attribute(attributeName, attributeType));
    }

    public Attribute getAttribute(String name) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public int getIndexOf(String name) {
        int index = 0;
        for (Attribute attribute : this.attributes) {
            if (attribute.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Vector<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean canAccept(Heading heading) {
        if (this.getDegree() != heading.getDegree()) {
            return false;
        }
        for (Attribute attribute : this.attributes) {
            Attribute foreignAttribute = heading.getAttribute(attribute.getName());
            if (foreignAttribute == null) {
                return false;
            }
            if (attribute.getType().canAccept(foreignAttribute.getType())) continue;
            return false;
        }
        return true;
    }

    public boolean requiresReformatOf(Heading source) {
        if (!this.canAccept(source)) {
            return true;
        }
        int i = 0;
        for (Attribute attribute : this.attributes) {
            if (attribute.getName().compareTo(source.attributes.get(i).getName()) != 0) {
                return true;
            }
            if (attribute.getType().requiresReformatOf(source.attributes.get(i).getType())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Heading getMostSpecificCommonSupertype(Heading tupleHeading) {
        if (this.getDegree() != tupleHeading.getDegree()) {
            throw new ExceptionSemantic("RS0251: Heading degrees do not match.");
        }
        Heading newHeading = new Heading();
        int i = 0;
        while (i < this.attributes.size()) {
            Attribute attribute = this.attributes.get(i);
            Type t1 = attribute.getType();
            String name = attribute.getName();
            Attribute attribute2 = tupleHeading.getAttribute(name);
            if (attribute2 == null) {
                throw new ExceptionSemantic("RS0252: Attribute '" + name + "' not found.");
            }
            Type t2 = attribute2.getType();
            if (!(t1 instanceof TypeAlpha)) {
                throw new ExceptionFatal("RS0380: getMostSpecificCommonSupertype: heading1 element " + i + " not TypeAlpha or derivative.");
            }
            if (!(t2 instanceof TypeAlpha)) {
                throw new ExceptionFatal("RS0381: getMostSpecificCommonSupertype: heading2 element " + i + " not TypeAlpha or derivative.");
            }
            TypeAlpha mostSpecificCommonSupertype = ((TypeAlpha)t1).getMostSpecificCommonSupertype((TypeAlpha)t2);
            if (mostSpecificCommonSupertype == null || mostSpecificCommonSupertype.getSignature().equals("ALPHA")) {
                throw new ExceptionSemantic("RS0253: ALPHA is the most specific common supertype of " + t1.getSignature() + " and " + t2.getSignature() + ", but ALPHA can't be selected.");
            }
            newHeading.add(name, mostSpecificCommonSupertype);
            ++i;
        }
        return newHeading;
    }

    public void changeTypeOfAttribute(String attributeName, Type newType) {
        int i = 0;
        while (i < this.attributes.size()) {
            if (this.attributes.get(i).getName().equals(attributeName)) {
                this.attributes.set(i, new Attribute(attributeName, newType));
                return;
            }
            ++i;
        }
        throw new ExceptionSemantic("RS0252: Attribute '" + attributeName + "' not found.");
    }

    @Override
    public int compareTo(Heading heading) {
        if (this.canAccept(heading)) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo((Heading)object) == 0;
    }

    public int getDegree() {
        return this.attributes.size();
    }

    public String getSpecification() {
        String out = null;
        for (Attribute attribute : this.attributes) {
            String string = out = out == null ? attribute.toString() : String.valueOf(out) + ", " + attribute.toString();
        }
        return out == null ? "" : out;
    }

    public String getSignature() {
        return "{" + this.getSpecification() + "}";
    }

    public String toString() {
        return this.getSignature();
    }

    public String getRandomFreeAttributeName() {
        String uuid = UUID.randomUUID().toString();
        while (this.getIndexOf(uuid) >= 0) {
            uuid = UUID.randomUUID().toString();
        }
        return uuid;
    }
}

