/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Attribute;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueTuple;

public class JoinMap {
    private int degree;
    private int[] leftCommonToRight;
    private boolean[] rightExclude;
    private int commonDegree;

    public JoinMap(Heading destinationType, Heading leftType, Heading rightType) {
        this.degree = destinationType.getDegree();
        Heading intersection = leftType.intersect(rightType);
        if (intersection.getDegree() == 0) {
            throw new ExceptionFatal("RS0382: " + leftType + " and " + rightType + " have no common attributes, and therefore need not be mapped.");
        }
        this.leftCommonToRight = new int[leftType.getDegree()];
        this.rightExclude = new boolean[rightType.getDegree()];
        int leftAttributeIndex = 0;
        for (Attribute attribute : leftType.getAttributes()) {
            int rightAttributeIndex = rightType.getIndexOf(attribute.getName());
            this.leftCommonToRight[leftAttributeIndex++] = rightAttributeIndex;
            if (rightAttributeIndex < 0) continue;
            this.rightExclude[rightAttributeIndex] = true;
        }
        this.commonDegree = 0;
        int i = 0;
        while (i < this.leftCommonToRight.length) {
            this.commonDegree += this.leftCommonToRight[i] >= 0 ? 1 : 0;
            ++i;
        }
    }

    public boolean isJoinable(ValueTuple left, ValueTuple right) {
        Value[] leftValues = left.getValues();
        Value[] rightValues = right.getValues();
        int i = 0;
        while (i < this.leftCommonToRight.length) {
            if (this.leftCommonToRight[i] >= 0 && leftValues[i].compareTo(rightValues[this.leftCommonToRight[i]]) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ValueTuple getLeftTupleCommon(Generator generator, ValueTuple left) {
        Value[] leftValues = left.getValues();
        Value[] leftCommonValues = new Value[this.commonDegree];
        int leftIndex = 0;
        int i = 0;
        while (i < this.leftCommonToRight.length) {
            if (this.leftCommonToRight[i] >= 0) {
                leftCommonValues[leftIndex++] = leftValues[i];
            }
            ++i;
        }
        return new ValueTuple(generator, leftCommonValues);
    }

    public ValueTuple getRightTupleCommon(Generator generator, ValueTuple right) {
        Value[] rightValues = right.getValues();
        Value[] rightCommonValues = new Value[this.commonDegree];
        int rightIndex = 0;
        int i = 0;
        while (i < this.leftCommonToRight.length) {
            if (this.leftCommonToRight[i] >= 0) {
                rightCommonValues[rightIndex++] = rightValues[this.leftCommonToRight[i]];
            }
            ++i;
        }
        return new ValueTuple(generator, rightCommonValues);
    }

    public ValueTuple join(Generator generator, ValueTuple left, ValueTuple right) {
        Value[] leftValues = left.getValues();
        Value[] rightValues = right.getValues();
        Value[] target = new Value[this.degree];
        System.arraycopy(leftValues, 0, target, 0, leftValues.length);
        int destinationIndex = leftValues.length;
        int i = 0;
        while (i < rightValues.length) {
            if (!this.rightExclude[i]) {
                target[destinationIndex++] = rightValues[i];
            }
            ++i;
        }
        return new ValueTuple(generator, target);
    }

    public ValueTuple joinChecked(Generator generator, ValueTuple left, ValueTuple right) {
        Value[] leftValues = left.getValues();
        Value[] rightValues = right.getValues();
        Value[] target = new Value[this.degree];
        int destinationIndex = 0;
        int i = 0;
        while (i < this.leftCommonToRight.length) {
            if (this.leftCommonToRight[i] >= 0 && leftValues[i].compareTo(rightValues[this.leftCommonToRight[i]]) != 0) {
                throw new ExceptionSemantic("RS0254: Common attributes differ in value.");
            }
            target[destinationIndex++] = leftValues[i];
            ++i;
        }
        i = 0;
        while (i < rightValues.length) {
            if (!this.rightExclude[i]) {
                target[destinationIndex++] = rightValues[i];
            }
            ++i;
        }
        return new ValueTuple(generator, target);
    }

    public String toString() {
        String outLR = null;
        int i = 0;
        while (i < this.leftCommonToRight.length) {
            if (this.leftCommonToRight[i] >= 0) {
                outLR = String.valueOf(outLR == null ? "" : String.valueOf(outLR) + ", ") + i + "=" + this.leftCommonToRight[i];
            }
            ++i;
        }
        String outR = "";
        int i2 = 0;
        while (i2 < this.rightExclude.length) {
            outR = String.valueOf(outR) + (this.rightExclude[i2] ? "x" : "_");
            ++i2;
        }
        return "JoinMap commonLR=[" + (outLR == null ? "" : outLR) + "] excludeR=[" + outR + "]";
    }
}

