/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.SelectOrder;
import org.reldb.rel.v0.types.Heading;

public class OrderMap {
    private int[] map;
    private SelectOrder.Order[] order;

    public OrderMap(Heading heading, SelectOrder orderItems) {
        int count = orderItems.getCount();
        this.map = new int[count];
        this.order = new SelectOrder.Order[count];
        int i = 0;
        while (i < count) {
            SelectOrder.Item item = orderItems.getItem(i);
            this.map[i] = heading.getIndexOf(item.getName());
            if (this.map[i] < 0) {
                throw new ExceptionSemantic("RS0255: Attribute " + item.getName() + " is not found in " + heading);
            }
            this.order[i] = item.getOrder();
            ++i;
        }
    }

    public int[] getMap() {
        return this.map;
    }

    public SelectOrder.Order[] getOrder() {
        return this.order;
    }

    public String toString() {
        String out = "";
        int i = 0;
        while (i < this.map.length) {
            if (i > 0) {
                out = String.valueOf(out) + ", ";
            }
            out = String.valueOf(out) + this.map[i] + "=" + (Object)((Object)this.order[i]);
            ++i;
        }
        return "OrderMap [" + out + "]";
    }
}

