/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Vector;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAbstract;
import org.reldb.rel.v0.types.userdefined.MultipleInheritance;
import org.reldb.rel.v0.types.userdefined.Possrep;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;
import org.reldb.rel.v0.vm.VirtualMachine;

public class TypeAlpha
extends TypeAbstract
implements Comparable<TypeAlpha> {
    private static TypeAlpha emptyAlpha = new TypeAlpha("ALPHA");
    private String typeName;
    private boolean isOrdinal;
    private boolean isOrdered;
    private boolean isUnion;
    private TypeAlpha superType = null;
    private MultipleInheritance multipleInheritanceDefinition = null;
    private Operator specialisationConstraintFn = null;
    private HashSet<TypeAlpha> subTypes = new HashSet();
    private Vector<Possrep> possreps = new Vector();
    private int nextComponentIndex = 0;

    public TypeAlpha(String typeName) {
        this.typeName = typeName;
    }

    public static Type getEmptyAlphaType() {
        return emptyAlpha;
    }

    public boolean isBuiltin() {
        return false;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setOrdinal(boolean ordinal) {
        this.isOrdinal = ordinal;
    }

    public boolean isOrdinal() {
        return this.isOrdinal;
    }

    public void setOrdered(boolean ordered) {
        this.isOrdered = ordered;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setUnion(boolean union) {
        this.isUnion = union;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public Type getRootType() {
        if (this.superType == null) {
            return this;
        }
        return this.superType.getRootType();
    }

    public void setSupertype(TypeAlpha superType) {
        this.superType = superType;
        superType.addSubtype(this);
        this.multipleInheritanceDefinition = null;
    }

    public TypeAlpha getSupertype() {
        return this.superType;
    }

    public LinkedList<TypeAlpha> getSupertypes() {
        LinkedList<TypeAlpha> list = new LinkedList<TypeAlpha>();
        TypeAlpha type = this.superType;
        while (type != null) {
            list.add(type);
            type = type.superType;
        }
        return list;
    }

    public TypeAlpha getMostSpecificCommonSupertype(TypeAlpha t) {
        if (this == t) {
            return this;
        }
        if (this.superType == t.superType) {
            return this.superType;
        }
        LinkedList<TypeAlpha> parentsOfThisNode = this.getSupertypes();
        TypeAlpha parent = t.superType;
        while (parent != null) {
            for (TypeAlpha listItem : parentsOfThisNode) {
                if (listItem != parent) continue;
                return listItem;
            }
            parent = parent.superType;
        }
        throw new ExceptionFatal("RS0383: Unable to find most specific common supertype.");
    }

    public void addSubtype(TypeAlpha subType) {
        this.subTypes.add(subType);
    }

    public void removeSubtype(TypeAlpha subType) {
        this.subTypes.remove(subType);
    }

    public void removeFromSupertype() {
        this.superType.removeSubtype(this);
    }

    public HashSet<TypeAlpha> getSubtypes() {
        return this.subTypes;
    }

    public void setMultipleInheritance(MultipleInheritance miDefinition) {
        this.multipleInheritanceDefinition = miDefinition;
        this.superType = null;
        this.possreps.clear();
    }

    public MultipleInheritance getMultipleInheritanceDefinition() {
        return this.multipleInheritanceDefinition;
    }

    public boolean isSubtype() {
        return this.superType != null || this.multipleInheritanceDefinition != null;
    }

    public int getNextComponentIndex() {
        if (this.isSubtype()) {
            return this.superType.getNextComponentIndex();
        }
        return this.nextComponentIndex++;
    }

    public Possrep locatePossrep(String name) {
        for (Possrep p : this.possreps) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public void addPossrep(Possrep possrep) {
        if (this.locatePossrep(possrep.getName()) != null) {
            throw new ExceptionSemantic("RS0256: A POSSREP named '" + possrep.getName() + "' has already been defined in TYPE " + this.getSignature() + ".");
        }
        int i = 0;
        while (i < possrep.getComponentCount()) {
            for (Possrep p : this.possreps) {
                String name;
                if (p.locateComponent(name = possrep.getComponent(i).getName()) == null) continue;
                throw new ExceptionSemantic("RS0257: Component '" + name + "' appears in POSSREP '" + p.getName() + "' and POSSREP '" + possrep.getName() + "'.");
            }
            ++i;
        }
        this.possreps.add(possrep);
    }

    public Possrep getPossrep(int i) {
        if (i >= this.possreps.size()) {
            return null;
        }
        return this.possreps.get(i);
    }

    public int getPossrepCount() {
        return this.possreps.size();
    }

    public void clear() {
        this.possreps.clear();
    }

    public void checkPossrepInitialisation() {
        int i = 0;
        while (i < this.getPossrepCount()) {
            Possrep possrep = this.getPossrep(i);
            if (!possrep.hasInitialiser()) {
                throw new ExceptionSemantic("RS0258: POSSREP '" + possrep.getName() + "' has no INITialisation.");
            }
            ++i;
        }
    }

    private int getLocalComponentCount() {
        return this.nextComponentIndex;
    }

    public int getComponentCount() {
        if (this.superType != null) {
            return this.getLocalComponentCount() + this.superType.getComponentCount();
        }
        if (this.multipleInheritanceDefinition != null) {
            throw new ExceptionFatal("TypeUserdefined: Multiple inheritance is not yet supported.");
        }
        return this.getLocalComponentCount();
    }

    @Override
    public String getSignature() {
        return this.typeName;
    }

    @Override
    public boolean canAccept(Type source) {
        if (!(source instanceof TypeAlpha)) {
            return false;
        }
        if (((TypeAlpha)source).superType == null) {
            return source.getSignature().equals(this.getSignature());
        }
        TypeAlpha subtypeType = (TypeAlpha)source;
        while (subtypeType != null) {
            if (subtypeType.getSignature().equals(this.getSignature())) {
                return true;
            }
            subtypeType = subtypeType.superType;
        }
        return false;
    }

    @Override
    public Value getDefaultValue(Generator generator) {
        return new ValueAlpha(generator, this);
    }

    public boolean checkSpecialisationConstraint(Generator generator, ValueAlpha value, RelDatabase database) {
        if (this.specialisationConstraintFn == null) {
            return true;
        }
        VirtualMachine vm = new VirtualMachine(generator, database, System.out);
        Context context = new Context(generator, vm);
        context.push(value);
        context.call(this.specialisationConstraintFn);
        return ((ValueBoolean)context.pop()).booleanValue();
    }

    public void setSpecialisationConstraint(Operator operator) {
        this.specialisationConstraintFn = operator;
    }

    public boolean hasSpecialisationConstraint() {
        return this.specialisationConstraintFn != null;
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public int compareTo(TypeAlpha arg0) {
        return this.typeName.compareTo(arg0.typeName);
    }
}

