/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeHeading;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueArray;

public class TypeArray
extends TypeHeading {
    public TypeArray(Heading heading) {
        super(heading);
    }

    @Override
    public Value getDefaultValue(Generator generator) {
        return new ValueArray(generator);
    }

    public static TypeArray getEmptyArrayType() {
        return new TypeArray(new Heading());
    }

    @Override
    public boolean canAccept(Type source) {
        if (source.getClass() != this.getClass()) {
            return false;
        }
        return this.getElementType().canAccept(((TypeArray)source).getElementType());
    }

    @Override
    public boolean requiresReformatOf(Type type) {
        if (!(type instanceof TypeArray)) {
            throw new ExceptionSemantic("RS0259: Expected an ARRAY but got a " + type + " in an operator invocation.");
        }
        return this.getElementType().requiresReformatOf(((TypeArray)type).getElementType());
    }

    public TypeTuple getElementType() {
        return new TypeTuple(this.heading);
    }

    public boolean canHoldElement(Type source) {
        return this.getElementType().canAccept(source);
    }

    @Override
    public String getSignature() {
        return "ARRAY " + this.getElementType().getSignature();
    }
}

