/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAbstract;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueOperator;
import org.reldb.rel.v0.vm.Operator;

public class TypeOperator
extends TypeAbstract {
    private static TypeOperator instance = new TypeOperator();
    private OperatorSignature signature;
    private static ValueOperator NOOP = null;

    public TypeOperator() {
        this.signature = null;
    }

    public TypeOperator(OperatorSignature signature) {
        this.signature = signature;
    }

    public static TypeOperator getInstance() {
        return instance;
    }

    public OperatorSignature getOperatorSignature() {
        return this.signature;
    }

    @Override
    public String getSignature() {
        return "OPERATOR" + (this.signature != null ? " " + this.signature : "");
    }

    @Override
    public boolean canAccept(Type source) {
        if (source.getClass() != this.getClass()) {
            return false;
        }
        if (this.signature == null) {
            return false;
        }
        if (!(source instanceof TypeOperator)) {
            return false;
        }
        TypeOperator sourceOperatorType = (TypeOperator)source;
        if (sourceOperatorType.signature == null) {
            return false;
        }
        return this.signature.canBeInvokedBy(sourceOperatorType.signature);
    }

    private static void makeNOPop(Generator generator) {
        if (NOOP == null) {
            NOOP = new ValueOperator(generator, new Operator(0), "OPERATOR (); END OPERATOR");
        }
    }

    @Override
    public Value getDefaultValue(Generator generator) {
        TypeOperator.makeNOPop(generator);
        return NOOP;
    }

    protected Type canCompare(Type v) {
        throw new ExceptionSemantic("RS0262: Cannot perform comparison between " + this + " and " + v);
    }
}

