/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.types.userdefined;

import java.util.ArrayList;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.userdefined.PossrepComponent;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;
import org.reldb.rel.v0.vm.VirtualMachine;

public class Possrep {
    private String name;
    private ArrayList<PossrepComponent> components = new ArrayList();
    private TypeAlpha type = null;
    private Operator constraintFn = null;
    private Operator initialiserFn = null;

    public Possrep(TypeAlpha type, String name) {
        this.type = type;
        this.name = name;
        type.addPossrep(this);
    }

    public TypeAlpha getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setConstraint(Operator constraintFn) {
        this.constraintFn = constraintFn;
    }

    public boolean hasConstraint() {
        return this.constraintFn != null;
    }

    public boolean checkConstraint(Generator generator, ValueAlpha value, RelDatabase database) {
        if (this.constraintFn == null) {
            return true;
        }
        VirtualMachine vm = new VirtualMachine(generator, database, System.out);
        Context context = new Context(generator, vm);
        context.push(value);
        context.call(this.constraintFn);
        return ((ValueBoolean)context.pop()).booleanValue();
    }

    public void setInitialiser(Operator operator) {
        this.initialiserFn = operator;
    }

    public boolean hasInitialiser() {
        return this.initialiserFn != null;
    }

    public void runInitialiser(Generator generator, ValueAlpha value, RelDatabase database) {
        if (!this.hasInitialiser()) {
            return;
        }
        VirtualMachine vm = new VirtualMachine(generator, database, System.out);
        Context context = new Context(generator, vm);
        context.push(value);
        context.call(this.initialiserFn);
    }

    public PossrepComponent locateComponent(String name) {
        for (PossrepComponent component : this.components) {
            if (!component.getName().equals(name)) continue;
            return component;
        }
        return null;
    }

    public void addComponent(PossrepComponent component) {
        if (this.locateComponent(component.getName()) != null) {
            throw new ExceptionSemantic("RS0239: A component named '" + component.getName() + "' has already been defined in POSSREP " + this.getName() + ".");
        }
        this.components.add(component);
    }

    public PossrepComponent getComponent(int n) {
        return this.components.get(n);
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public int getNextComponentIndex() {
        return this.type.getNextComponentIndex();
    }
}

