/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.util.ArrayList;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueTuple;

public class TupleIteratorCount
extends TupleIterator {
    private ArrayList<ValueTuple> tupleSet;
    private ValueTuple current;
    private Generator generator;
    private long count;
    private int index;

    public TupleIteratorCount(TupleIterator source, Generator generator) {
        this.generator = generator;
        this.tupleSet = new ArrayList();
        while (source.hasNext()) {
            this.tupleSet.add(source.next());
        }
        source.close();
        this.count = 0L;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.tupleSet.size()) {
            return false;
        }
        this.current = this.tupleSet.get(this.index);
        ++this.index;
        int i = 0;
        while (i < this.tupleSet.size()) {
            if (this.current.equals(this.tupleSet.get(i))) {
                ++this.count;
            }
            ++i;
        }
        return true;
    }

    @Override
    public ValueTuple next() {
        try {
            ValueTuple valueTuple = this.createCountTuple().joinDisjoint(this.current);
            return valueTuple;
        }
        finally {
            this.current = null;
            this.count = 0L;
        }
    }

    @Override
    public void close() {
        this.index = 0;
    }

    private ValueTuple createCountTuple() {
        Value[] value = new Value[]{ValueInteger.select(this.generator, this.count)};
        return new ValueTuple(this.generator, value);
    }
}

