/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.util.HashSet;
import java.util.NoSuchElementException;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueTuple;

public class TupleIteratorDisjoint
extends TupleIterator {
    private TupleIterator source;
    private HashSet<ValueTuple> tupleSet;

    public TupleIteratorDisjoint(TupleIterator source) {
        this.source = source;
        this.tupleSet = new HashSet();
    }

    @Override
    public boolean hasNext() {
        return this.source.hasNext();
    }

    @Override
    public ValueTuple next() {
        if (this.hasNext()) {
            ValueTuple tuple = this.source.next();
            if (this.tupleSet.contains(tuple)) {
                throw new ExceptionSemantic("RS0264: Requirement that tuples be disjoint has been violated.");
            }
            this.tupleSet.add(tuple);
            return tuple;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        this.source.close();
    }
}

