/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.util.HashSet;
import java.util.NoSuchElementException;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.ValueTuple;

public class TupleIteratorUnique
extends TupleIterator {
    private TupleIterator source;
    private HashSet<ValueTuple> tupleSet;
    private ValueTuple current;

    public TupleIteratorUnique(TupleIterator source) {
        this.source = source;
        this.tupleSet = new HashSet();
        this.current = null;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        do {
            if (!this.source.hasNext()) {
                return false;
            }
            this.current = this.source.next();
        } while (this.tupleSet.contains(this.current));
        this.tupleSet.add(this.current);
        return true;
    }

    @Override
    public ValueTuple next() {
        if (this.hasNext()) {
            try {
                ValueTuple valueTuple = this.current;
                return valueTuple;
            }
            finally {
                this.current = null;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        this.source.close();
    }
}

