/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.vm.Context;

public abstract class ValueAbstract
implements Value {
    private static final long serialVersionUID = 1L;
    private transient Generator generator;

    public ValueAbstract(Generator generator) {
        this.generator = generator;
    }

    @Override
    public void loaded(Generator generator) {
        this.generator = generator;
    }

    protected Generator getGenerator() {
        return this.generator;
    }

    @Override
    public void toStream(Context context, Type type, PrintStream p, int depth) {
        if (depth > 0) {
            p.print(this.toParsableString(type));
        } else {
            p.print(this.toString(type));
        }
    }

    @Override
    public boolean equals(Object v) {
        return this.compareTo((Value)v) == 0;
    }

    @Override
    public String toParsableString(Type type) {
        return this.toString();
    }

    @Override
    public String toString(Type type) {
        return this.toString();
    }

    @Override
    public Value getSerializableClone() {
        return this;
    }

    @Override
    public boolean booleanValue() {
        throw new ExceptionSemantic("RS0265: Cannot convert " + this.getTypeName() + " to BOOLEAN.");
    }

    @Override
    public long longValue() {
        throw new ExceptionSemantic("RS0266: Cannot convert " + this.getTypeName() + " to INTEGER.");
    }

    @Override
    public double doubleValue() {
        throw new ExceptionSemantic("RS0267: Cannot convert " + this.getTypeName() + " to RATIONAL.");
    }

    @Override
    public String stringValue() {
        throw new ExceptionSemantic("RS0268: Cannot convert " + this.getTypeName() + " to CHARACTER.");
    }
}

