/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.userdefined.Possrep;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAbstract;
import org.reldb.rel.v0.vm.Context;

public class ValueAlpha
extends ValueAbstract {
    private static final long serialVersionUID = 0L;
    private String initialTypeName;
    private String typeName;
    private Value[] internal;
    private int possrepNumber;
    private volatile boolean hasBeenSerializablyCloned = false;

    public ValueAlpha(Generator generator, TypeAlpha type, Value[] v, int possrepNumber) {
        super(generator);
        this.typeName = this.initialTypeName = type.getTypeName();
        this.possrepNumber = possrepNumber;
        this.internal = new Value[type.getComponentCount()];
        Possrep possrep = type.getPossrep(possrepNumber);
        int possrepComponentCount = possrep.getComponentCount();
        if (v.length != possrepComponentCount) {
            throw new ExceptionFatal("RS0384: select parameter count != POSSREP component count.");
        }
        int componentIndex = 0;
        while (componentIndex < possrepComponentCount) {
            this.internal[possrep.getComponent((int)componentIndex).getComponentIndex()] = v[componentIndex];
            ++componentIndex;
        }
    }

    public ValueAlpha(Generator generator, TypeAlpha type) {
        super(generator);
        this.typeName = this.initialTypeName = type.getTypeName();
        this.internal = new Value[type.getComponentCount()];
        this.possrepNumber = -1;
    }

    @Override
    public Value getSerializableClone() {
        if (this.hasBeenSerializablyCloned) {
            return this;
        }
        int i = 0;
        while (i < this.internal.length) {
            this.internal[i] = this.internal[i] == null ? null : this.internal[i].getSerializableClone();
            ++i;
        }
        this.hasBeenSerializablyCloned = true;
        return this;
    }

    @Override
    public void loaded(Generator generator) {
        super.loaded(generator);
        Value[] valueArray = this.internal;
        int n = this.internal.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v != null) {
                v.loaded(generator);
            }
            ++n2;
        }
    }

    public void setMST(TypeAlpha mst) {
        if (!this.typeName.equals(mst.getTypeName())) {
            this.typeName = mst.getTypeName();
            this.possrepNumber = 0;
        }
    }

    @Override
    public int hashCode() {
        int code = 0;
        Value[] valueArray = this.internal;
        int n = this.internal.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (v != null) {
                code += v.hashCode();
            }
            ++n2;
        }
        return code;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public Value getComponentValue(int offsetInValue) {
        return this.internal[offsetInValue];
    }

    public void setComponentValue(int offsetInValue, Value value) {
        this.internal[offsetInValue] = value;
    }

    private void noConversions() {
        throw new ExceptionSemantic("RS0269: Cannot convert a " + this.typeName + " to a primitive value.");
    }

    @Override
    public boolean booleanValue() {
        this.noConversions();
        return false;
    }

    @Override
    public long longValue() {
        this.noConversions();
        return 0L;
    }

    @Override
    public double doubleValue() {
        this.noConversions();
        return 0.0;
    }

    @Override
    public String stringValue() {
        String out = null;
        int i = 0;
        while (i < this.internal.length) {
            out = String.valueOf(out == null ? "" : String.valueOf(out) + ", ") + (this.internal[i] == null ? "null" : this.internal[i].toString());
            ++i;
        }
        return out == null ? "" : out;
    }

    @Override
    public boolean equals(Object o) {
        throw new ExceptionFatal("RS0385: Bogus 'equals' performed on ALPHA!");
    }

    @Override
    public int compareTo(Value v) {
        boolean allNull = true;
        int comparison = 0;
        int i = 0;
        while (i < this.internal.length) {
            Value v1 = this.internal[i];
            Value v2 = ((ValueAlpha)v).internal[i];
            if (v1 == null && v2 == null) {
                comparison = 0;
            } else if (v1 != null && v2 == null) {
                comparison = 1;
            } else if (v1 == null && v2 != null) {
                comparison = -1;
            } else {
                comparison = v1.compareTo(v2);
                allNull = false;
            }
            if (comparison != 0) break;
            ++i;
        }
        if (comparison == 0 && allNull) {
            return this.getTypeName().compareTo(v.getTypeName());
        }
        return comparison;
    }

    public String toString() {
        String out = "{";
        int i = 0;
        while (i < this.internal.length) {
            if (i > 0) {
                out = String.valueOf(out) + "|";
            }
            out = String.valueOf(out) + (this.internal[i] == null ? "<null>" : this.internal[i].toString());
            ++i;
        }
        return String.valueOf(out) + "}";
    }

    public Type getType(RelDatabase database) {
        Generator generator = this.getGenerator();
        Type mst = database.loadType(generator, this.typeName);
        if (mst == null) {
            mst = database.loadType(generator, this.initialTypeName);
            this.setMST((TypeAlpha)mst);
        }
        if (mst == null) {
            throw new ExceptionFatal("RS0387: Unable to load MST " + this.initialTypeName);
        }
        return mst;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void toStream(Context context, Type contextualType, PrintStream p, int depth) {
        block10: {
            if (contextualType == null) {
                throw new ExceptionFatal("RS0388: contextualType is null.");
            }
            possrepIndex = -1;
            type = this.getType(context.getVirtualMachine().getRelDatabase());
            if (type == null) {
                udt = (TypeAlpha)contextualType;
                possrepIndex = udt.getPossrepCount() <= 0 ? -1 : 0;
            } else {
                udt = (TypeAlpha)type;
                possrepIndex = this.possrepNumber;
            }
            if (possrepIndex != -1) ** GOTO lbl19
            p.print(String.valueOf(udt.getTypeName()) + "()");
            break block10;
lbl-1000:
            // 1 sources

            {
                superudt = udt.getSupertype();
                if (superudt == null) {
                    p.print(String.valueOf(udt.getTypeName()) + "()");
                    return;
                }
                udt = superudt;
lbl19:
                // 2 sources

                ** while ((possrep = udt.getPossrep((int)possrepIndex)) == null)
            }
lbl20:
            // 1 sources

            p.print(String.valueOf(possrep.getName() == null ? udt.getTypeName() : possrep.getName()) + "(");
            i = 0;
            while (i < possrep.getComponentCount()) {
                if (i > 0) {
                    p.print(", ");
                }
                if ((v = this.internal[(component = possrep.getComponent(i)).getComponentIndex()]) != null) {
                    v.toStream(context, component.getType(), p, depth + 1);
                } else {
                    p.print("\"[null-" + udt.getTypeName() + "-null]\"");
                    System.out.println("ValueAlpha: invalid component at " + component.getComponentIndex() + " size of internal is " + this.internal.length + " type is " + udt.getTypeName());
                    x = 0;
                    while (x < this.internal.length) {
                        System.out.println("ValueAlpha:  internal[" + x + "] is " + this.internal[x]);
                        ++x;
                    }
                }
                ++i;
            }
            p.print(")");
        }
    }
}

