/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.AttributeMap;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.OrderMap;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeArray;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.values.Sorter;
import org.reldb.rel.v0.values.TupleFold;
import org.reldb.rel.v0.values.TupleFoldFirstIsIdentity;
import org.reldb.rel.v0.values.TupleIteratable;
import org.reldb.rel.v0.values.TupleIteration;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.TupleIteratorUnique;
import org.reldb.rel.v0.values.TupleMap;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAbstract;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRational;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;

public class ValueArray
extends ValueAbstract
implements TupleIteratable {
    private static final long serialVersionUID = 0L;
    private ArrayList<ValueTuple> values;
    private ValueRelation relation;

    public ValueArray(Generator generator) {
        super(generator);
        this.values = new ArrayList();
        this.relation = null;
    }

    ValueArray(Generator generator, ArrayList<ValueTuple> values) {
        super(generator);
        this.values = values;
        this.relation = null;
    }

    ValueArray(Generator generator, ValueRelation relation) {
        super(generator);
        this.values = null;
        this.relation = relation;
    }

    private void convertToArray() {
        try (TupleIterator iterator = this.relation.iterator();){
            this.values = new ArrayList();
            while (iterator.hasNext()) {
                this.values.add(iterator.next());
            }
            this.relation = null;
        }
    }

    @Override
    public Value project(final AttributeMap map) {
        return new ValueArray(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public TupleIterator iterator() {
                return new TupleIterator(){
                    TupleIterator tuples;
                    {
                        this.tuples = ValueArray.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.tuples.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        return (ValueTuple)this.tuples.next().project(map);
                    }

                    @Override
                    public void close() {
                        this.tuples.close();
                    }
                };
            }
        };
    }

    public ValueRelation toRelation() {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIteratorUnique(ValueArray.this.iterator());
            }
        };
    }

    @Override
    public String getTypeName() {
        return "ARRAY";
    }

    public long getCount() {
        if (this.values == null) {
            return this.relation.getCardinality();
        }
        return this.values.size();
    }

    private void checkIndexOutOfBounds(int index) {
        if (index >= this.values.size()) {
            if (this.values.size() == 0) {
                throw new ExceptionSemantic("RS0270: Array index " + index + " is out of bounds; array is empty.");
            }
            throw new ExceptionSemantic("RS0271: Array index " + index + " is out of bounds; highest index is " + (this.values.size() - 1) + ".");
        }
        if (index < 0) {
            throw new ExceptionSemantic("RS0272: Array index " + index + " is out of bounds; it's less than 0.");
        }
    }

    public Value get(int index) {
        if (this.values == null) {
            this.convertToArray();
        }
        this.checkIndexOutOfBounds(index);
        return this.values.get(index);
    }

    public void set(int index, ValueTuple value) {
        if (this.values == null) {
            this.convertToArray();
        }
        this.checkIndexOutOfBounds(index);
        this.values.set(index, value);
    }

    public void append(ValueTuple value) {
        if (this.values == null) {
            this.convertToArray();
        }
        this.values.add(value);
    }

    @Override
    public TupleIterator iterator() {
        if (this.values == null) {
            return this.relation.iterator();
        }
        return new TupleIterator(){
            Iterator<ValueTuple> iterator;
            {
                this.iterator = ValueArray.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public ValueTuple next() {
                return this.iterator.next();
            }

            @Override
            public void close() {
            }
        };
    }

    private void toStreamFromRelation(Context context, Type type, PrintStream p, int depth) {
        TypeTuple tupleType = ((TypeArray)type).getElementType();
        Heading heading = tupleType.getHeading();
        if (depth == 0) {
            p.print("ARRAY " + heading + " {");
        } else {
            p.print("ARRAY {");
        }
        long count = 0L;
        try (TupleIterator iterator = this.relation.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (count++ > 0L) {
                    p.print(',');
                }
                p.print("\n\t");
                tuple.toStream(context, tupleType, p, depth + 1);
            }
        }
        p.print("\n}");
    }

    private void toStreamFromArray(Context context, Type type, PrintStream p, int depth) {
        TypeTuple elementType = ((TypeArray)type).getElementType();
        Heading heading = elementType.getHeading();
        p.print("ARRAY " + heading + " {");
        long count = 0L;
        for (Value value : this.values) {
            if (count++ > 0L) {
                p.print(',');
            }
            p.print("\n\t");
            value.toStream(context, elementType, p, depth + 1);
        }
        p.print("\n}");
    }

    @Override
    public void toStream(Context context, Type type, PrintStream p, int depth) {
        if (this.values == null) {
            this.toStreamFromRelation(context, type, p, depth);
        } else {
            this.toStreamFromArray(context, type, p, depth);
        }
    }

    @Override
    public int hashCode() {
        int code = 0;
        for (Value value : this.values) {
            code += value.hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(Value v) {
        throw new ExceptionSemantic("RS0273: ARRAY does not support comparison.");
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "ARRAY {";
        long count = 0L;
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (count++ > 0L) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + tuple.toString();
            }
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    @Override
    public TupleIteratable map(final TupleMap map) {
        return new ValueArray(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator iterator() {
                return new TupleIterator(){
                    TupleIterator iterator;
                    {
                        this.iterator = ValueArray.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        return map.map(this.iterator.next());
                    }

                    @Override
                    public void close() {
                        this.iterator.close();
                    }
                };
            }
        };
    }

    @Override
    public Value sort(OrderMap map) {
        if (map.getMap().length == 0) {
            return this;
        }
        final ArrayList<ValueTuple> array = new ArrayList<ValueTuple>();
        new TupleIteration(this.iterator()){

            @Override
            public void process(ValueTuple tuple) {
                array.add(tuple);
            }
        }.run();
        Collections.sort(array, new Sorter(map));
        return new ValueArray(this.getGenerator(), array);
    }

    public Value sumInteger(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueInteger.select(ValueArray.this.getGenerator(), 0L);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueInteger.select(ValueArray.this.getGenerator(), left.longValue() + right.longValue());
            }
        };
        folder.run();
        return folder.getResult();
    }

    public Value sumRational(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueRational.select(ValueArray.this.getGenerator(), 0.0);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueRational.select(ValueArray.this.getGenerator(), left.doubleValue() + right.doubleValue());
            }
        };
        folder.run();
        return folder.getResult();
    }

    public ValueRational avgInteger(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueInteger.select(ValueArray.this.getGenerator(), 0L);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueInteger.select(ValueArray.this.getGenerator(), left.longValue() + right.longValue());
            }
        };
        folder.run();
        Value sum = folder.getResult();
        if (folder.getCount() == 0L) {
            throw new ExceptionSemantic("RS0276: Result of AVG on no values is undefined.");
        }
        return ValueRational.select(this.getGenerator(), sum.doubleValue() / (double)folder.getCount());
    }

    public ValueRational avgRational(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueRational.select(ValueArray.this.getGenerator(), 0.0);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueRational.select(ValueArray.this.getGenerator(), left.doubleValue() + right.doubleValue());
            }
        };
        folder.run();
        Value sum = folder.getResult();
        if (folder.getCount() == 0L) {
            throw new ExceptionSemantic("RS0277: Result of AVG on no values is undefined.");
        }
        return ValueRational.select(this.getGenerator(), sum.doubleValue() / (double)folder.getCount());
    }

    public Value max(int attributeIndex) {
        TupleFoldFirstIsIdentity folder = new TupleFoldFirstIsIdentity("Result of MAX on no values is undefined.", this.iterator(), attributeIndex){

            @Override
            public Value fold(Value left, Value right) {
                if (left.compareTo(right) > 0) {
                    return left;
                }
                return right;
            }
        };
        folder.run();
        return folder.getResult();
    }

    public Value min(int attributeIndex) {
        TupleFoldFirstIsIdentity folder = new TupleFoldFirstIsIdentity("Result of MIN on no values is undefined.", this.iterator(), attributeIndex){

            @Override
            public Value fold(Value left, Value right) {
                if (left.compareTo(right) < 0) {
                    return left;
                }
                return right;
            }
        };
        folder.run();
        return folder.getResult();
    }

    public ValueBoolean and(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueBoolean.select(ValueArray.this.getGenerator(), true);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueBoolean.select(ValueArray.this.getGenerator(), left.booleanValue() & right.booleanValue());
            }
        };
        folder.run();
        return (ValueBoolean)folder.getResult();
    }

    public ValueBoolean or(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueBoolean.select(ValueArray.this.getGenerator(), false);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueBoolean.select(ValueArray.this.getGenerator(), left.booleanValue() | right.booleanValue());
            }
        };
        folder.run();
        return (ValueBoolean)folder.getResult();
    }

    public ValueBoolean xor(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value getIdentity() {
                return ValueBoolean.select(ValueArray.this.getGenerator(), false);
            }

            @Override
            public Value fold(Value left, Value right) {
                return ValueBoolean.select(ValueArray.this.getGenerator(), left.booleanValue() ^ right.booleanValue());
            }
        };
        folder.run();
        return (ValueBoolean)folder.getResult();
    }

    public ValueRelation union(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value fold(Value left, Value right) {
                return ((ValueRelation)left).union((ValueRelation)right);
            }

            @Override
            public Value getIdentity() {
                return new ValueRelationLiteral(ValueArray.this.getGenerator());
            }
        };
        folder.run();
        return (ValueRelation)folder.getResult();
    }

    public Value xunion(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value fold(Value left, Value right) {
                return ((ValueRelation)left).xunion((ValueRelation)right);
            }

            @Override
            public Value getIdentity() {
                return new ValueRelationLiteral(ValueArray.this.getGenerator());
            }
        };
        folder.run();
        return (ValueRelation)folder.getResult();
    }

    public ValueRelation d_union(int attributeIndex) {
        TupleFold folder = new TupleFold(this.iterator(), attributeIndex){

            @Override
            public Value fold(Value left, Value right) {
                return ((ValueRelation)left).dunion((ValueRelation)right);
            }

            @Override
            public Value getIdentity() {
                return new ValueRelationLiteral(ValueArray.this.getGenerator());
            }
        };
        folder.run();
        return (ValueRelation)folder.getResult();
    }

    public ValueRelation intersect(int attributeIndex) {
        TupleFoldFirstIsIdentity folder = new TupleFoldFirstIsIdentity("Result of INTERSECT on no values is undefined.", this.iterator(), attributeIndex){

            @Override
            public Value fold(Value left, Value right) {
                return ((ValueRelation)left).intersect((ValueRelation)right);
            }
        };
        folder.run();
        return (ValueRelation)folder.getResult();
    }
}

