/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.builtin.TypeBoolean;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.vm.Context;

public class ValueBoolean
extends ValueAlpha
implements Comparable<Value> {
    private static final long serialVersionUID = 0L;
    private boolean internalValue;

    public static ValueBoolean select(Generator generator, boolean x) {
        return (ValueBoolean)generator.selectValue(TypeBoolean.getInstance(), new ValueBoolean(generator, x));
    }

    private ValueBoolean(Generator generator, boolean b) {
        super(generator, TypeBoolean.getInstance(), new Value[1], 0);
        this.internalValue = b;
    }

    @Override
    public Value getComponentValue(int offsetInValue) {
        return ValueBoolean.select(this.getGenerator(), this.internalValue);
    }

    @Override
    public void setComponentValue(int offsetInValue, Value value) {
        this.internalValue = value.booleanValue();
    }

    @Override
    public void toStream(Context context, Type contextualType, PrintStream p, int depth) {
        Generator generator = this.getGenerator();
        TypeAlpha type = (TypeAlpha)this.getType(context.getVirtualMachine().getRelDatabase());
        this.setMST(generator.findMST(type, new ValueBoolean(generator, this.internalValue)));
        String typeSignature = this.getType(generator.getDatabase()).getSignature();
        if (typeSignature.equals("BOOLEAN")) {
            p.print(this.internalValue);
        } else {
            p.print(String.valueOf(typeSignature) + "(" + this.internalValue + ")");
        }
    }

    @Override
    public boolean booleanValue() {
        return this.internalValue;
    }

    @Override
    public long longValue() {
        return this.internalValue ? 1 : 0;
    }

    @Override
    public double doubleValue() {
        return this.internalValue ? 1 : 0;
    }

    @Override
    public String stringValue() {
        return this.internalValue ? "true" : "false";
    }

    @Override
    public int hashCode() {
        return Boolean.valueOf(this.internalValue).hashCode();
    }

    @Override
    public int compareTo(Value v) {
        if (this.internalValue == v.booleanValue()) {
            return 0;
        }
        if (this.internalValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public String toString() {
        return "" + this.internalValue;
    }
}

