/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.builtin.TypeCharacter;
import org.reldb.rel.v0.values.StringUtils;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.vm.Context;

public class ValueCharacter
extends ValueAlpha
implements Comparable<Value> {
    private static final long serialVersionUID = 0L;
    private String internalValue;

    public static String stripDelimitedString(String b) {
        return StringUtils.unquote(b.substring(1, b.length() - 1));
    }

    public static Value stripDelimited(Generator generator, String b) {
        return new ValueCharacter(generator, ValueCharacter.stripDelimitedString(b));
    }

    public static ValueCharacter select(Generator generator, String x) {
        return (ValueCharacter)generator.selectValue(TypeCharacter.getInstance(), new ValueCharacter(generator, x));
    }

    private ValueCharacter(Generator generator, String b) {
        super(generator, TypeCharacter.getInstance(), new Value[1], 0);
        this.internalValue = b;
    }

    @Override
    public Value getComponentValue(int offsetInValue) {
        return ValueCharacter.select(this.getGenerator(), this.internalValue);
    }

    @Override
    public void setComponentValue(int offsetInValue, Value value) {
        this.internalValue = value.stringValue();
    }

    @Override
    public void toStream(Context context, Type contextualType, PrintStream p, int depth) {
        Generator generator = this.getGenerator();
        TypeAlpha type = (TypeAlpha)this.getType(context.getVirtualMachine().getRelDatabase());
        this.setMST(generator.findMST(type, new ValueCharacter(generator, this.internalValue)));
        String typeSignature = this.getType(generator.getDatabase()).getSignature();
        if (typeSignature.equals("CHARACTER")) {
            p.print(depth > 0 ? this.toParsableString(contextualType) : this.toString());
        } else {
            p.print(String.valueOf(typeSignature) + "(" + this.toParsableString(contextualType) + ")");
        }
    }

    @Override
    public boolean booleanValue() {
        return this.internalValue.compareToIgnoreCase("true") == 0;
    }

    @Override
    public long longValue() {
        try {
            return (long)Double.parseDouble(this.internalValue);
        }
        catch (NumberFormatException nfe) {
            throw new ExceptionSemantic("RS0390: '" + this.internalValue + "' isn't a valid number.");
        }
    }

    @Override
    public double doubleValue() {
        try {
            return Double.parseDouble(this.internalValue);
        }
        catch (NumberFormatException nfe) {
            throw new ExceptionSemantic("RS0391: '" + this.internalValue + "' isn't a valid number.");
        }
    }

    @Override
    public String stringValue() {
        return this.internalValue;
    }

    @Override
    public int hashCode() {
        return this.internalValue.hashCode();
    }

    @Override
    public int compareTo(Value v) {
        return this.internalValue.compareTo(v.stringValue());
    }

    @Override
    public String toString() {
        return this.internalValue;
    }

    @Override
    public String toParsableString(Type type) {
        return "\"" + StringUtils.quote(this.internalValue) + "\"";
    }
}

