/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.vm.Context;

public class ValueInteger
extends ValueAlpha
implements Comparable<Value> {
    private static final long serialVersionUID = 0L;
    private long internalValue;

    public static ValueInteger select(Generator generator, long x) {
        return (ValueInteger)generator.selectValue(TypeInteger.getInstance(), new ValueInteger(generator, x));
    }

    private ValueInteger(Generator generator, long b) {
        super(generator, TypeInteger.getInstance(), new Value[1], 0);
        this.internalValue = b;
    }

    @Override
    public Value getComponentValue(int offsetInValue) {
        return ValueInteger.select(this.getGenerator(), this.internalValue);
    }

    @Override
    public void setComponentValue(int offsetInValue, Value value) {
        this.internalValue = value.longValue();
    }

    @Override
    public void toStream(Context context, Type contextualType, PrintStream p, int depth) {
        Generator generator = this.getGenerator();
        TypeAlpha type = (TypeAlpha)this.getType(context.getVirtualMachine().getRelDatabase());
        this.setMST(generator.findMST(type, new ValueInteger(generator, this.internalValue)));
        String typeSignature = this.getType(generator.getDatabase()).getSignature();
        if (typeSignature.equals("INTEGER")) {
            p.print(this.internalValue);
        } else {
            p.print(String.valueOf(typeSignature) + "(" + this.internalValue + ")");
        }
    }

    @Override
    public boolean booleanValue() {
        return this.internalValue != 0L;
    }

    @Override
    public long longValue() {
        return this.internalValue;
    }

    @Override
    public double doubleValue() {
        return this.internalValue;
    }

    @Override
    public String stringValue() {
        return "" + this.internalValue;
    }

    @Override
    public int hashCode() {
        return Long.valueOf(this.internalValue).hashCode();
    }

    @Override
    public int compareTo(Value v) {
        if (this.internalValue == v.longValue()) {
            return 0;
        }
        if (this.internalValue > v.longValue()) {
            return 1;
        }
        return -1;
    }

    public Value add(Generator generator, Value v) {
        return new ValueInteger(generator, this.internalValue + v.longValue());
    }

    @Override
    public String toString() {
        return "" + this.internalValue;
    }
}

