/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import java.io.Serializable;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAbstract;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;

public class ValueOperator
extends ValueAbstract
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String source;
    private volatile Operator operator;
    private volatile Context enclosingContext;

    public ValueOperator(Generator generator, Operator operator, String source) {
        super(generator);
        this.operator = operator;
        this.source = source;
        this.enclosingContext = null;
        this.loaded(generator);
    }

    @Override
    public void loaded(Generator generator) {
        super.loaded(generator);
    }

    public void setEnclosingContext(Context context) {
        this.enclosingContext = context;
    }

    public Context getEnclosingContext() {
        return this.enclosingContext;
    }

    @Override
    public Value getSerializableClone() {
        return new ValueOperator(this.getGenerator(), null, this.source);
    }

    @Override
    public String getTypeName() {
        return "OPERATOR";
    }

    public Operator getOperator(Generator generator) {
        if (this.operator == null) {
            this.operator = generator.getDatabase().compileAnonymousOperator((String)this.getSource(), (PrintStream)generator.getPrintStream()).operator;
        }
        return this.operator;
    }

    public void toStream(Generator generator, Context context, Type type, PrintStream p, int depth) {
        p.print(this.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(Value v) {
        return this.getSource().compareTo(((ValueOperator)v).getSource());
    }

    public String getSource() {
        return "OPERATOR " + this.source + " END OPERATOR";
    }

    public String toString() {
        return "\"" + this.getSource() + "\"";
    }
}

