/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeAlpha;
import org.reldb.rel.v0.types.builtin.TypeRational;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.vm.Context;

public class ValueRational
extends ValueAlpha
implements Comparable<Value> {
    private static final long serialVersionUID = 0L;
    private double internalValue;

    public static ValueRational select(Generator generator, double x) {
        return (ValueRational)generator.selectValue(TypeRational.getInstance(), new ValueRational(generator, x));
    }

    private ValueRational(Generator generator, double b) {
        super(generator, TypeRational.getInstance(), new Value[1], 0);
        this.internalValue = b;
    }

    @Override
    public Value getComponentValue(int offsetInValue) {
        return ValueRational.select(this.getGenerator(), this.internalValue);
    }

    @Override
    public void setComponentValue(int offsetInValue, Value value) {
        this.internalValue = value.doubleValue();
    }

    @Override
    public void toStream(Context context, Type contextualType, PrintStream p, int depth) {
        Generator generator = this.getGenerator();
        TypeAlpha type = (TypeAlpha)this.getType(context.getVirtualMachine().getRelDatabase());
        this.setMST(generator.findMST(type, new ValueRational(generator, this.internalValue)));
        String typeSignature = this.getType(generator.getDatabase()).getSignature();
        if (typeSignature.equals("RATIONAL")) {
            p.print(this.internalValue);
        } else {
            p.print(String.valueOf(typeSignature) + "(" + this.internalValue + ")");
        }
    }

    @Override
    public boolean booleanValue() {
        return this.internalValue != 0.0;
    }

    @Override
    public long longValue() {
        return (long)this.internalValue;
    }

    @Override
    public double doubleValue() {
        return this.internalValue;
    }

    @Override
    public String stringValue() {
        return "" + this.internalValue;
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.internalValue).hashCode();
    }

    @Override
    public int compareTo(Value v) {
        if (this.internalValue == v.doubleValue()) {
            return 0;
        }
        if (this.internalValue > v.doubleValue()) {
            return 1;
        }
        return -1;
    }

    @Override
    public String toString() {
        return "" + this.internalValue;
    }
}

