/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.storage.temporary.TempIndex;
import org.reldb.rel.v0.storage.temporary.TempIndexImplementation;
import org.reldb.rel.v0.types.AttributeMap;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.JoinMap;
import org.reldb.rel.v0.types.OrderMap;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeRelation;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.types.builtin.TypeInteger;
import org.reldb.rel.v0.values.Projectable;
import org.reldb.rel.v0.values.Sorter;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIteratable;
import org.reldb.rel.v0.values.TupleIteration;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.TupleIteratorDisjoint;
import org.reldb.rel.v0.values.TupleIteratorUnique;
import org.reldb.rel.v0.values.TupleMap;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAbstract;
import org.reldb.rel.v0.values.ValueArray;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueInteger;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;

public abstract class ValueRelation
extends ValueAbstract
implements Projectable,
TupleIteratable {
    private static final long serialVersionUID = 0L;
    private HashSet<ValueTuple> cache = null;

    public ValueRelation(Generator generator) {
        super(generator);
    }

    @Override
    public Value getSerializableClone() {
        ValueRelationLiteral newRelation = new ValueRelationLiteral(this.getGenerator());
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                newRelation.insert((ValueTuple)iterator.next().getSerializableClone());
            }
        }
        return newRelation;
    }

    public static ValueRelation getDum(Generator generator) {
        return new ValueRelation(generator){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public ValueTuple next() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public static ValueRelation getDee(Generator generator) {
        return new ValueRelation(generator){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 1;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    public boolean available = true;

                    @Override
                    public boolean hasNext() {
                        return this.available;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.available) {
                            try {
                                ValueTuple valueTuple = ValueTuple.getEmptyTuple(this.getGenerator());
                                return valueTuple;
                            }
                            finally {
                                this.available = false;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
        };
    }

    public ValueTuple getTuple() {
        try (TupleIterator iterator = this.iterator();){
            if (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (!iterator.hasNext()) {
                    ValueTuple valueTuple = tuple;
                    return valueTuple;
                }
            }
        }
        throw new ExceptionSemantic("RS0274: TUPLE FROM expects a relation with cardinality equal to one.");
    }

    @Override
    public Value project(final AttributeMap map) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIteratorUnique(new TupleIterator(){
                    TupleIterator tuples;
                    {
                        this.tuples = ValueRelation.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.tuples.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        return (ValueTuple)this.tuples.next().project(map);
                    }

                    @Override
                    public void close() {
                        this.tuples.close();
                    }
                });
            }
        };
    }

    public ValueRelation union(final ValueRelation rightRelation) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIteratorUnique(new TupleIterator(rightRelation){
                    TupleIterator left;
                    TupleIterator right;
                    {
                        this.left = ValueRelation.this.iterator();
                        this.right = valueRelation.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.left.hasNext() || this.right.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.left.hasNext()) {
                            return this.left.next();
                        }
                        if (this.right.hasNext()) {
                            return this.right.next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.left.close();
                        this.right.close();
                    }
                });
            }
        };
    }

    public ValueRelation xunion(ValueRelation rightRelation) {
        return this.union(rightRelation).minus(this.intersect(rightRelation));
    }

    public ValueRelation dunion(final ValueRelation rightRelation) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIteratorDisjoint(new TupleIterator(rightRelation){
                    TupleIterator left;
                    TupleIterator right;
                    {
                        this.left = ValueRelation.this.iterator();
                        this.right = valueRelation.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.left.hasNext() || this.right.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.left.hasNext()) {
                            return this.left.next();
                        }
                        if (this.right.hasNext()) {
                            return this.right.next();
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.left.close();
                        this.right.close();
                    }
                });
            }
        };
    }

    public ValueRelation intersect(final ValueRelation rightRelation) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    TupleIterator left;
                    ValueTuple current;
                    {
                        this.left = ValueRelation.this.iterator();
                        this.current = null;
                    }

                    @Override
                    public boolean hasNext() {
                        ValueTuple leftTuple;
                        if (this.current != null) {
                            return true;
                        }
                        do {
                            if (this.left.hasNext()) continue;
                            return false;
                        } while (!rightRelation.contains(leftTuple = this.left.next()));
                        this.current = leftTuple;
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.left.close();
                    }
                };
            }
        };
    }

    public ValueRelation minus(final ValueRelation rightRelation) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    TupleIterator left;
                    ValueTuple current;
                    {
                        this.left = ValueRelation.this.iterator();
                        this.current = null;
                    }

                    @Override
                    public boolean hasNext() {
                        ValueTuple leftTuple;
                        if (this.current != null) {
                            return true;
                        }
                        do {
                            if (this.left.hasNext()) continue;
                            return false;
                        } while (rightRelation.contains(leftTuple = this.left.next()));
                        this.current = leftTuple;
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.left.close();
                    }
                };
            }
        };
    }

    public Value iminus(ValueRelation rightRelation) {
        if (!rightRelation.isSubsetOf(this)) {
            throw new ExceptionSemantic("RS0275: In I_MINUS, the right operand must be a subset of the left operand.");
        }
        return this.minus(rightRelation);
    }

    public ValueRelation product(final ValueRelation rightRelation) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    TupleIterator left;
                    TupleIterator right;
                    ValueTuple current;
                    ValueTuple leftTuple;
                    {
                        this.left = ValueRelation.this.iterator();
                        this.right = null;
                        this.current = null;
                        this.leftTuple = null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current != null) {
                            return true;
                        }
                        if (this.leftTuple != null) {
                            if (!this.right.hasNext()) {
                                this.leftTuple = null;
                            } else {
                                this.current = this.leftTuple.joinDisjoint(this.right.next());
                                return true;
                            }
                        }
                        if (this.leftTuple == null) {
                            if (!this.left.hasNext()) {
                                return false;
                            }
                            this.leftTuple = this.left.next();
                            if (this.right != null) {
                                this.right.close();
                            }
                            this.right = rightRelation.iterator();
                            if (!this.right.hasNext()) {
                                return false;
                            }
                            this.current = this.leftTuple.joinDisjoint(this.right.next());
                        }
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.left.close();
                        if (this.right != null) {
                            this.right.close();
                        }
                    }
                };
            }
        };
    }

    public ValueRelation join(final RelDatabase database, final JoinMap map, final ValueRelation rightRelation) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(database){
                    boolean indexed = false;
                    TempIndex rightTuples;
                    TupleIterator leftIterator;
                    TupleIterator rightIterator;
                    ValueTuple current;
                    ValueTuple leftTuple;
                    ValueTuple rightTuple;
                    {
                        this.rightTuples = new TempIndexImplementation(relDatabase);
                        this.leftIterator = ValueRelation.this.iterator();
                        this.current = null;
                        this.leftTuple = null;
                        this.rightTuple = null;
                    }

                    public boolean hasNextPair() {
                        while (true) {
                            if (this.rightIterator == null) {
                                if (!this.leftIterator.hasNext()) {
                                    return false;
                                }
                                this.leftTuple = this.leftIterator.next();
                                this.rightIterator = this.indexed ? this.rightTuples.keySearch(map.getLeftTupleCommon(this.getGenerator(), this.leftTuple)) : rightRelation.iterator();
                            }
                            if (this.rightIterator.hasNext()) {
                                this.rightTuple = this.rightIterator.next();
                                if (this.indexed) {
                                    return true;
                                }
                                ValueTuple rightClone = (ValueTuple)this.rightTuple.getSerializableClone();
                                this.rightTuples.put(map.getRightTupleCommon(this.getGenerator(), rightClone), rightClone);
                                if (!map.isJoinable(this.leftTuple, this.rightTuple)) continue;
                                return true;
                            }
                            this.indexed = true;
                            this.rightIterator.close();
                            this.rightIterator = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current != null) {
                            return true;
                        }
                        if (!this.hasNextPair()) {
                            return false;
                        }
                        this.current = this.leftTuple.join(map, this.rightTuple);
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        if (this.rightIterator != null) {
                            this.rightIterator.close();
                        }
                        this.leftIterator.close();
                        this.rightTuples.close();
                    }
                };
            }
        };
    }

    @Override
    public TupleIteratable map(final TupleMap map) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    TupleIterator iterator;
                    {
                        this.iterator = ValueRelation.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public ValueTuple next() {
                        return map.map(this.iterator.next());
                    }

                    @Override
                    public void close() {
                        this.iterator.close();
                    }
                };
            }
        };
    }

    public ValueRelation ungroup(final int resultDegree, final AttributeMap sourceMap, final AttributeMap rvaMap, final int rvaIndex) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    ValueTuple current = null;
                    TupleIterator outerIterator;
                    TupleIterator innerIterator;
                    ValueTuple outerTuple;
                    boolean done;
                    {
                        this.outerIterator = ValueRelation.this.iterator();
                        this.innerIterator = null;
                        this.done = false;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    public boolean hasNext() {
                        if (this.done) {
                            return false;
                        }
                        if (this.current == null) ** GOTO lbl13
                        return true;
lbl-1000:
                        // 1 sources

                        {
                            if (!this.outerIterator.hasNext()) {
                                this.done = true;
                                return false;
                            }
                            this.outerTuple = this.outerIterator.next();
                            if (this.innerIterator != null) {
                                this.innerIterator.close();
                            }
                            this.innerIterator = ((ValueRelation)this.outerTuple.getValues()[rvaIndex]).iterator();
                            if (this.innerIterator.hasNext()) break;
lbl13:
                            // 2 sources

                            ** while (this.innerIterator == null || !this.innerIterator.hasNext())
                        }
lbl14:
                        // 2 sources

                        buffer = new Value[resultDegree];
                        this.current = new ValueTuple(this.getGenerator(), buffer);
                        this.current.assign(rvaMap, this.innerIterator.next());
                        this.current.assign(sourceMap, this.outerTuple);
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.outerIterator.close();
                        if (this.innerIterator != null) {
                            this.innerIterator.close();
                        }
                    }
                };
            }
        };
    }

    public ValueRelation select(final TupleFilter filter) {
        return new ValueRelation(this.getGenerator()){
            private static final long serialVersionUID = 0L;

            @Override
            public int hashCode() {
                return 0;
            }

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(){
                    TupleIterator iterator;
                    ValueTuple current;
                    {
                        this.iterator = ValueRelation.this.iterator();
                        this.current = null;
                    }

                    @Override
                    public boolean hasNext() {
                        ValueTuple next;
                        boolean testResult;
                        if (this.current != null) {
                            return true;
                        }
                        do {
                            if (this.iterator.hasNext()) continue;
                            return false;
                        } while (!(testResult = filter.filter(next = this.iterator.next())));
                        this.current = next;
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                        this.iterator.close();
                    }
                };
            }
        };
    }

    public static Value sequence(final Generator generator, final ValueInteger start, final ValueInteger end, final ValueInteger step) {
        return new ValueRelation(generator){
            private static final long serialVersionUID = 1L;

            @Override
            public TupleIterator newIterator() {
                return new TupleIterator(start){
                    long currentValue;
                    ValueTuple current;
                    {
                        this.currentValue = valueInteger.longValue();
                        this.current = this.getCurrentValue();
                    }

                    private ValueTuple getCurrentValue() {
                        return new ValueTuple(generator, new Value[]{ValueInteger.select(generator, this.currentValue)});
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current != null) {
                            return true;
                        }
                        this.currentValue += step.longValue();
                        if (step.longValue() > 0L ? this.currentValue > end.longValue() : this.currentValue < end.longValue()) {
                            return false;
                        }
                        this.current = this.getCurrentValue();
                        return true;
                    }

                    @Override
                    public ValueTuple next() {
                        if (this.hasNext()) {
                            try {
                                ValueTuple valueTuple = this.current;
                                return valueTuple;
                            }
                            finally {
                                this.current = null;
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void close() {
                    }
                };
            }

            @Override
            public int hashCode() {
                return 0;
            }
        };
    }

    public static Value sequence(Generator generator, ValueInteger start, ValueInteger end) {
        return ValueRelation.sequence(generator, start, end, ValueInteger.select(generator, 1L));
    }

    @Override
    public ValueArray sort(OrderMap map) {
        if (map.getMap().length == 0) {
            return new ValueArray(this.getGenerator(), this);
        }
        final ArrayList<ValueTuple> array = new ArrayList<ValueTuple>();
        new TupleIteration(this.iterator()){

            @Override
            public void process(ValueTuple tuple) {
                array.add(tuple);
            }
        }.run();
        Collections.sort(array, new Sorter(map));
        return new ValueArray(this.getGenerator(), array);
    }

    public abstract TupleIterator newIterator();

    @Override
    public abstract int hashCode();

    @Override
    public final TupleIterator iterator() {
        return this.newIterator();
    }

    private void buildCache() {
        this.cache = new HashSet();
        new TupleIteration(this.iterator()){

            @Override
            public void process(ValueTuple tuple) {
                ValueRelation.this.cache.add(tuple);
            }
        }.run();
    }

    public boolean contains(ValueTuple findMe) {
        if (this.cache == null) {
            this.buildCache();
        }
        return this.cache.contains(findMe);
    }

    @Override
    public String getTypeName() {
        return "RELATION";
    }

    @Override
    public void toStream(Context context, Type type, PrintStream p, int depth) {
        Heading heading = ((TypeRelation)type).getHeading();
        TypeTuple tupleType = new TypeTuple(heading);
        p.print("RELATION " + heading + " {");
        long count = 0L;
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (count++ > 0L) {
                    p.print(',');
                }
                p.print("\n\t");
                tuple.toStream(context, tupleType, p, depth + 1);
            }
        }
        p.print("\n}");
    }

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "RELATION {";
        long count = 0L;
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (count++ > 0L) {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + tuple.toString();
            }
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    public long getCardinality() {
        if (this.cache == null) {
            this.buildCache();
        }
        return this.cache.size();
    }

    private final boolean isTestedSubsetOf(ValueRelation rightSide) {
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (rightSide.contains(tuple)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSubsetOf(ValueRelation rightSide) {
        if (this.getCardinality() > rightSide.getCardinality()) {
            return false;
        }
        return this.isTestedSubsetOf(rightSide);
    }

    public boolean isSupersetOf(ValueRelation v) {
        return v.isSubsetOf(this);
    }

    public boolean isProperSupersetOf(ValueRelation v) {
        return v.isProperSubsetOf(this);
    }

    public boolean isProperSubsetOf(ValueRelation v) {
        return this.isSubsetOf(v) && this.neq(v);
    }

    @Override
    public int compareTo(Value v) {
        long cardinalityRight;
        ValueRelation rightSide = (ValueRelation)v;
        long cardinalityLeft = this.getCardinality();
        if (cardinalityLeft == (cardinalityRight = rightSide.getCardinality())) {
            return this.isTestedSubsetOf(rightSide) ? 0 : 1;
        }
        return 1;
    }

    public boolean eq(ValueRelation rightSide) {
        if (this.getCardinality() == rightSide.getCardinality()) {
            return this.isTestedSubsetOf(rightSide);
        }
        return false;
    }

    public boolean neq(ValueRelation v) {
        return !this.eq(v);
    }

    private static ValueRelation tclose(Generator generator, JoinMap joinMap, AttributeMap projectMap, ValueRelation xy) {
        ValueRelation ttt = xy.union((ValueRelation)xy.join(generator.getDatabase(), joinMap, xy).project(projectMap));
        return ttt.eq(xy) ? ttt : ValueRelation.tclose(generator, joinMap, projectMap, ttt);
    }

    public Value tclose() {
        TypeInteger attributeType = TypeInteger.getInstance();
        Heading left = new Heading();
        left.add("X", attributeType);
        left.add("LINK", attributeType);
        Heading right = new Heading();
        right.add("LINK", attributeType);
        right.add("Y", attributeType);
        Heading joinTarget = new Heading();
        joinTarget.add("X", attributeType);
        joinTarget.add("LINK", attributeType);
        joinTarget.add("Y", attributeType);
        Heading projectTarget = new Heading();
        projectTarget.add("X", attributeType);
        projectTarget.add("Y", attributeType);
        JoinMap joinMap = new JoinMap(joinTarget, left, right);
        AttributeMap projectMap = new AttributeMap(projectTarget, joinTarget);
        return ValueRelation.tclose(this.getGenerator(), joinMap, projectMap, this);
    }

    public ValueBoolean is_empty() {
        try (TupleIterator iterator = this.iterator();){
            ValueBoolean valueBoolean = ValueBoolean.select(this.getGenerator(), !iterator.hasNext());
            return valueBoolean;
        }
    }

    public ValueBoolean exactly(long nCount, int attributeIndex) {
        long trueCount = 0L;
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple t = iterator.next();
                trueCount += (long)(((ValueBoolean)t.getValues()[attributeIndex]).booleanValue() ? 1 : 0);
            }
        }
        return ValueBoolean.select(this.getGenerator(), trueCount == nCount);
    }
}

