/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.relvars.Relvar;
import org.reldb.rel.v0.values.RelTupleFilter;
import org.reldb.rel.v0.values.RelTupleMap;
import org.reldb.rel.v0.values.TupleFilter;
import org.reldb.rel.v0.values.TupleIterator;
import org.reldb.rel.v0.values.TupleMap;
import org.reldb.rel.v0.values.ValueRelation;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Operator;

public class ValueRelationLiteral
extends ValueRelation
implements Relvar {
    private static final long serialVersionUID = 0L;
    private int hashCode;
    private HashSet<ValueTuple> lookupTuples;
    private LinkedList<ValueTuple> iterationTuples;

    public ValueRelationLiteral(Generator generator) {
        super(generator);
        this.purge();
    }

    public boolean insert(ValueTuple tuple) {
        if (this.lookupTuples.add(tuple)) {
            this.iterationTuples.add(tuple);
            this.hashCode += tuple.hashCode();
            return true;
        }
        return false;
    }

    public void remove(ValueTuple tuple) {
        if (this.lookupTuples.remove(tuple)) {
            this.iterationTuples.remove(tuple);
            this.hashCode -= tuple.hashCode();
        }
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public TupleIterator newIterator() {
        return new TupleIterator(){
            ValueTuple currentTuple;
            Iterator<ValueTuple> i;
            {
                this.i = ValueRelationLiteral.this.iterationTuples.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ValueTuple next() {
                this.currentTuple = this.i.next();
                this.currentTuple.loaded(ValueRelationLiteral.this.getGenerator());
                return this.currentTuple;
            }

            @Override
            public void remove() {
                this.i.remove();
                ValueRelationLiteral.this.iterationTuples.remove(this.currentTuple);
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public long getCardinality() {
        return this.lookupTuples.size();
    }

    @Override
    public boolean contains(ValueTuple tuple) {
        return this.lookupTuples.contains(tuple);
    }

    @Override
    public TupleIterator iterator(Generator generator) {
        return this.iterator();
    }

    @Override
    public long getCardinality(Generator generator) {
        return this.getCardinality();
    }

    @Override
    public boolean contains(Generator generator, ValueTuple tuple) {
        return this.contains(tuple);
    }

    @Override
    public void setValue(ValueRelation relation) {
        this.purge();
        this.insert(this.getGenerator(), relation);
    }

    @Override
    public long insert(Generator generator, ValueTuple tuple) {
        if (this.insert(tuple)) {
            return 1L;
        }
        return 0L;
    }

    @Override
    public long insert(Generator generator, ValueRelation relation) {
        long insertCount = 0L;
        try (TupleIterator tuples = relation.iterator();){
            while (tuples.hasNext()) {
                insertCount += this.insert(generator, tuples.next());
            }
        }
        return insertCount;
    }

    @Override
    public long insertNoDuplicates(Generator generator, ValueRelation relation) {
        long insertCount = 0L;
        try (TupleIterator tuples = relation.iterator();){
            while (tuples.hasNext()) {
                if (this.insert(generator, tuples.next()) == 0L) {
                    throw new ExceptionSemantic("RS0394: inserting tuple would attempt to insert a duplicate.");
                }
                ++insertCount;
            }
        }
        return insertCount;
    }

    @Override
    public void purge() {
        this.lookupTuples = new HashSet();
        this.iterationTuples = new LinkedList();
        this.hashCode = 0;
    }

    @Override
    public long delete(Context context, Operator whereTupleOperator) {
        return this.delete(context.getGenerator(), new RelTupleFilter(context, whereTupleOperator));
    }

    public long update(Generator generator, TupleMap map) {
        return this.update(generator, new TupleFilter(){

            @Override
            public boolean filter(ValueTuple tuple) {
                return true;
            }
        }, map);
    }

    @Override
    public long update(Context context, Operator updateTupleOperator) {
        return this.update(context.getGenerator(), new RelTupleMap(context, updateTupleOperator));
    }

    @Override
    public long update(Context context, Operator whereTupleOperator, Operator updateTupleOperator) {
        return this.update(context.getGenerator(), new RelTupleFilter(context, whereTupleOperator), new RelTupleMap(context, updateTupleOperator));
    }

    public long update(Generator generator, TupleFilter whereFilter, TupleMap updateMap) {
        ValueRelationLiteral temp = new ValueRelationLiteral(generator);
        long updateCount = 0L;
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (!whereFilter.filter(tuple)) continue;
                ValueTuple newTuple = updateMap.map(tuple);
                iterator.remove();
                ValueTuple data = (ValueTuple)newTuple.getSerializableClone();
                temp.insert(data);
                ++updateCount;
            }
        }
        iterator = temp.iterator();
        try {
            while (iterator.hasNext()) {
                this.insert(iterator.next());
            }
        }
        finally {
            iterator.close();
        }
        return updateCount;
    }

    @Override
    public long delete(Generator generator, TupleFilter filter) {
        long deleteCount = 0L;
        try (TupleIterator iterator = this.iterator();){
            while (iterator.hasNext()) {
                ValueTuple tuple = iterator.next();
                if (!filter.filter(tuple)) continue;
                iterator.remove();
                ++deleteCount;
            }
        }
        return deleteCount;
    }

    @Override
    public long delete(Context context, ValueRelation tuplesToDelete, boolean errorIfNotIncluded) {
        final HashMap<ValueTuple, Boolean> toDelete = new HashMap<ValueTuple, Boolean>();
        Generator generator = context.getGenerator();
        try (TupleIterator iterator = tuplesToDelete.iterator();){
            while (iterator.hasNext()) {
                toDelete.put(iterator.next(), Boolean.FALSE);
            }
        }
        if (errorIfNotIncluded) {
            try (TupleIterator relvarTupleIterator = this.iterator(generator);){
                while (relvarTupleIterator.hasNext()) {
                    ValueTuple keyTuple = relvarTupleIterator.next();
                    if (!toDelete.containsKey(keyTuple)) continue;
                    toDelete.put(keyTuple, Boolean.TRUE);
                }
            }
            Collection values = toDelete.values();
            Iterator valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                if (((Boolean)valueIterator.next()).booleanValue()) continue;
                throw new ExceptionSemantic("RS0395: In I_DELETE, one or more specified tuples are not included in the relation-valued attribute.");
            }
        }
        return this.delete(generator, new TupleFilter(){

            @Override
            public boolean filter(ValueTuple tuple) {
                return toDelete.containsKey(tuple);
            }
        });
    }
}

