/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.values;

import java.io.PrintStream;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.Attribute;
import org.reldb.rel.v0.types.AttributeMap;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.types.JoinMap;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.types.TypeTuple;
import org.reldb.rel.v0.values.Projectable;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAbstract;
import org.reldb.rel.v0.vm.Context;

public class ValueTuple
extends ValueAbstract
implements Projectable {
    private static final long serialVersionUID = 0L;
    private Value[] values;

    public ValueTuple(Generator generator, TypeTuple type) {
        super(generator);
        Heading heading = type.getHeading();
        this.values = new Value[heading.getDegree()];
        int i = 0;
        for (Attribute attribute : heading.getAttributes()) {
            this.values[i++] = attribute.getType().getDefaultValue(generator);
        }
        this.loaded(generator);
    }

    public ValueTuple(Generator generator, Value[] values) {
        super(generator);
        this.values = values;
        this.loaded(generator);
    }

    @Override
    public void loaded(Generator generator) {
        super.loaded(generator);
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            if (value != null) {
                value.loaded(generator);
            }
            ++n2;
        }
    }

    @Override
    public Value getSerializableClone() {
        Value[] newValues = new Value[this.values.length];
        int i = 0;
        while (i < this.values.length) {
            newValues[i] = this.values[i].getSerializableClone();
            ++i;
        }
        return new ValueTuple(this.getGenerator(), newValues);
    }

    public static ValueTuple getEmptyTuple(Generator generator) {
        return new ValueTuple(generator, TypeTuple.getEmptyTupleType());
    }

    public Value[] getValues() {
        return this.values;
    }

    public void assign(AttributeMap map, ValueTuple source) {
        map.assign(this.values, source);
    }

    @Override
    public Value project(AttributeMap map) {
        return map.project(this.getGenerator(), this);
    }

    public ValueTuple joinDisjoint(ValueTuple right) {
        Value[] valueArray = new Value[this.values.length + right.values.length];
        System.arraycopy(this.values, 0, valueArray, 0, this.values.length);
        System.arraycopy(right.values, 0, valueArray, this.values.length, right.values.length);
        return new ValueTuple(this.getGenerator(), valueArray);
    }

    public ValueTuple join(JoinMap map, ValueTuple right) {
        return map.join(this.getGenerator(), this, right);
    }

    public ValueTuple joinChecked(JoinMap map, ValueTuple right) {
        return map.joinChecked(this.getGenerator(), this, right);
    }

    public ValueTuple shrink(int attributeIndex) {
        Value[] valueArray = new Value[this.values.length - 1];
        System.arraycopy(this.values, 0, valueArray, 0, attributeIndex);
        System.arraycopy(this.values, attributeIndex + 1, valueArray, attributeIndex, this.values.length - attributeIndex - 1);
        return new ValueTuple(this.getGenerator(), valueArray);
    }

    @Override
    public String getTypeName() {
        return "TUPLE";
    }

    @Override
    public void toStream(Context context, Type type, PrintStream p, int depth) {
        p.print("TUPLE {");
        int i = 0;
        for (Attribute attribute : ((TypeTuple)type).getHeading().getAttributes()) {
            if (i > 0) {
                p.print(", ");
            }
            p.print(String.valueOf(attribute.getName()) + " ");
            this.values[i].toStream(context, attribute.getType(), p, depth + 1);
            ++i;
        }
        p.print("}");
    }

    @Override
    public int hashCode() {
        int code = 0;
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            code += value.hashCode();
            ++n2;
        }
        return code;
    }

    @Override
    public int compareTo(Value v) {
        int comparison = 0;
        int i = 0;
        while (i < this.values.length) {
            comparison = this.values[i].compareTo(((ValueTuple)v).values[i]);
            if (comparison != 0) break;
            ++i;
        }
        return comparison;
    }

    public String toString() {
        String out = null;
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            out = String.valueOf(out == null ? "" : String.valueOf(out) + ", ") + (value == null ? "null" : value.toString());
            ++n2;
        }
        return "TUPLE {" + (out == null ? "" : out) + "}";
    }

    public String toCSV() {
        StringBuffer str = new StringBuffer("");
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            str.append(String.valueOf(value.toString()) + ",");
            ++n2;
        }
        str.deleteCharAt(str.length() - 1);
        return str.toString().trim();
    }
}

