/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.version;

public class Version {
    private static final int PRODUCT_VERSION = 1;
    private static final int DATABASE_VERSION = 0;
    private static final int REVISION = 13;
    private static final String RELEASE = "Beta";
    public static final String expectedBerkeleyDBVersion = "7.0.6";

    private Version() {
    }

    public static int getProductVersion() {
        return 1;
    }

    public static int getDatabaseVersion() {
        return 0;
    }

    public static String getCoreJarFilename(int dbVersion) {
        return String.format("rel%04d.jar", dbVersion);
    }

    public static String getCoreJarFilename() {
        return Version.getCoreJarFilename(Version.getDatabaseVersion());
    }

    public static String getBerkeleyDbJarFilename() {
        return "je-7.0.6.jar";
    }

    public static int getRevision() {
        return 13;
    }

    public static String getRelease() {
        return RELEASE;
    }

    public static String getNumericVersion() {
        return String.valueOf(Version.getProductVersion()) + "." + Version.getDatabaseVersion() + "." + Version.getRevision();
    }

    public static String getVersion() {
        return String.valueOf(Version.getNumericVersion()) + " " + Version.getRelease();
    }

    public static String getCopyright() {
        return "Rel DBMS version " + Version.getVersion() + "\n" + "Copyright (c) 2004 - 2016 Dave Voorhis\n" + "All Rights Reserved\n" + "For further information, please see http://reldb.org";
    }

    public static String getLicense() {
        return "Rel comes with ABSOLUTELY NO WARRANTY; for details, type:\n\twarranty FROM TUPLE FROM sys.Version\nThis is free software, and you are welcome to redistribute it\nunder certain conditions.\nFor details, type:\n\tredistribution FROM TUPLE FROM sys.Version\nTo view the catalog, type:\n\tsys.Catalog";
    }

    public static String getWarranty() {
        return "BECAUSE REL IS LICENSED FREE OF CHARGE,\nTHERE IS NO WARRANTY FOR REL, TO THE EXTENT\nPERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE\nSTATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER\nPARTIES PROVIDE REL 'AS IS' WITHOUT WARRANTY\nOF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,\nBUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\nMERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.\nTHE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE\nPROGRAM IS WITH YOU. SHOULD REL PROVE DEFECTIVE,\nYOU ASSUME THE COST OF ALL NECESSARY SERVICING,\nREPAIR OR CORRECTION.\n\nIN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR\nAGREED TO IN WRITING WILL ANY COPYRIGHT HOLDER,\nOR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE\nREL AS PERMITTED ABOVE, BE LIABLE TO YOU FOR\nDAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL\nOR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE\nOR INABILITY TO USE REL (INCLUDING BUT NOT\nLIMITED TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE\nOR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE\nOF REL TO OPERATE WITH ANY OTHER PROGRAMS),\nEVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED\nOF THE POSSIBILITY OF SUCH DAMAGES.";
    }

    public static String getRedistribution() {
        return "TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n1. Definitions.\n\n\"License\" shall mean the terms and conditions for use, reproduction,\nand distribution as defined by Sections 1 through 9 of this document.\n\n\"Licensor\" shall mean the copyright owner or entity authorized by the\ncopyright owner that is granting the License.\n\n\"Legal Entity\" shall mean the union of the acting entity and all other\nentities that control, are controlled by, or are under common control\nwith that entity. For the purposes of this definition, \"control\" means\n(i) the power, direct or indirect, to cause the direction or\nmanagement of such entity, whether by contract or otherwise, or (ii)\nownership of fifty percent (50%) or more of the outstanding shares, or\n(iii) beneficial ownership of such entity.\n\n\"You\" (or \"Your\") shall mean an individual or Legal Entity exercising\npermissions granted by this License.\n\n\"Source\" form shall mean the preferred form for making modifications,\nincluding but not limited to software source code, documentation\nsource, and configuration files.\n\n\"Object\" form shall mean any form resulting from mechanical\ntransformation or translation of a Source form, including but not\nlimited to compiled object code, generated documentation, and\nconversions to other media types.\n\n\"Work\" shall mean the work of authorship, whether in Source or Object\nform, made available under the License, as indicated by a copyright\nnotice that is included in or attached to the work.\n\n\"Derivative Works\" shall mean any work, whether in Source or Object\nform, that is based on (or derived from) the Work and for which the\neditorial revisions, annotations, elaborations, or other modifications\nrepresent, as a whole, an original work of authorship. For the\npurposes of this License, Derivative Works shall not include works\nthat remain separable from, or merely link (or bind by name) to the\ninterfaces of, the Work and Derivative Works thereof.\n\n\"Contribution\" shall mean any work of authorship, including the\noriginal version of the Work and any modifications or additions to\nthat Work or Derivative Works thereof, that is intentionally submitted\nto Licensor for inclusion in the Work by the copyright owner or by an\nindividual or Legal Entity authorized to submit on behalf of the\ncopyright owner. For the purposes of this definition, \"submitted\"\nmeans any form of electronic, verbal, or written communication sent to\nthe Licensor or its representatives, including but not limited to\ncommunication on electronic mailing lists, source code control\nsystems, and issue tracking systems that are managed by, or on behalf\nof, the Licensor for the purpose of discussing and improving the Work,\nbut excluding communication that is conspicuously marked or otherwise\ndesignated in writing by the copyright owner as \"Not a Contribution.\"\n\n\"Contributor\" shall mean Licensor and any individual or Legal Entity\non behalf of whom a Contribution has been received by Licensor and\nsubsequently incorporated within the Work.\n\n2. Grant of Copyright License. \n\nSubject to the terms and conditions of this License, each Contributor\nhereby grants to You a perpetual, worldwide, non-exclusive, no-charge,\nroyalty-free, irrevocable copyright license to reproduce, prepare\nDerivative Works of, publicly display, publicly perform, sublicense,\nand distribute the Work and such Derivative Works in Source or Object\nform.\n\n3. Grant of Patent License. \n\nSubject to the terms and conditions of this License, each Contributor\nhereby grants to You a perpetual, worldwide, non-exclusive, no-charge,\nroyalty-free, irrevocable (except as stated in this section) patent\nlicense to make, have made, use, offer to sell, sell, import, and\notherwise transfer the Work, where such license applies only to those\npatent claims licensable by such Contributor that are necessarily\ninfringed by their Contribution(s) alone or by combination of their\nContribution(s) with the Work to which such Contribution(s) was\nsubmitted. If You institute patent litigation against any entity\n(including a cross-claim or counterclaim in a lawsuit) alleging that\nthe Work or a Contribution incorporated within the Work constitutes\ndirect or contributory patent infringement, then any patent licenses\ngranted to You under this License for that Work shall terminate as of\nthe date such litigation is filed.\n\n4. Redistribution. \n\nYou may reproduce and distribute copies of the Work or Derivative\nWorks thereof in any medium, with or without modifications, and in\nSource or Object form, provided that You meet the following\nconditions:\n\n(a) You must give any other recipients of the Work or\n    Derivative Works a copy of this License; and\n\n(b) You must cause any modified files to carry prominent notices\n    stating that You changed the files; and\n\n(c) You must retain, in the Source form of any Derivative Works\n    that You distribute, all copyright, patent, trademark, and\n    attribution notices from the Source form of the Work,\n    excluding those notices that do not pertain to any part of\n    the Derivative Works; and within a display generated by the\n    Derivative Works, if and wherever such third-party notices\n    normally appear. The contents of the NOTICE file are for\n    informational purposes only and do not modify the License.\n    You may add Your own attribution notices within Derivative\n    Works that You distribute, alongside or as an addendum to the\n    NOTICE text from the Work, provided that such additional\n    attribution notices cannot be construed as modifying the License.\n\nYou may add Your own copyright statement to Your modifications and may\nprovide additional or different license terms and conditions for use,\nreproduction, or distribution of Your modifications, or for any such\nDerivative Works as a whole, provided Your use, reproduction, and\ndistribution of the Work otherwise complies with the conditions stated\nin this License.\n\n5. Submission of Contributions. \n\nUnless You explicitly state otherwise, any Contribution intentionally\nsubmitted for inclusion in the Work by You to the Licensor shall be\nunder the terms and conditions of this License, without any additional\nterms or conditions.  Notwithstanding the above, nothing herein shall\nsupersede or modify the terms of any separate license agreement you\nmay have executed with Licensor regarding such Contributions.\n\n6. Trademarks. \n\nThis License does not grant permission to use the trade names,\ntrademarks, service marks, or product names of the Licensor, except as\nrequired for reasonable and customary use in describing the origin of\nthe Work and reproducing the content of the NOTICE file.\n\n7. Disclaimer of Warranty. \n\nUnless required by applicable law or agreed to in writing, Licensor\nprovides the Work (and each Contributor provides its Contributions) on\nan \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either\nexpress or implied, including, without limitation, any warranties or\nconditions of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR\nA PARTICULAR PURPOSE. You are solely responsible for determining the\nappropriateness of using or redistributing the Work and assume any\nrisks associated with Your exercise of permissions under this License.\n\n8. Limitation of Liability. \n\nIn no event and under no legal theory, whether in tort (including\nnegligence), contract, or otherwise, unless required by applicable law\n(such as deliberate and grossly negligent acts) or agreed to in\nwriting, shall any Contributor be liable to You for damages, including\nany direct, indirect, special, incidental, or consequential damages of\nany character arising as a result of this License or out of the use or\ninability to use the Work (including but not limited to damages for\nloss of goodwill, work stoppage, computer failure or malfunction, or\nany and all other commercial damages or losses), even if such\nContributor has been advised of the possibility of such damages.\n\n9. Accepting Warranty or Additional Liability. \n\nWhile redistributing the Work or Derivative Works thereof, You may\nchoose to offer, and charge a fee for, acceptance of support,\nwarranty, indemnity, or other liability obligations and/or rights\nconsistent with this License. However, in accepting such obligations,\nYou may act only on Your own behalf and on Your sole responsibility,\nnot on behalf of any other Contributor, and only if You agree to\nindemnify, defend, and hold each Contributor harmless for any\nliability incurred by, or claims asserted against, such Contributor by\nreason of your accepting any such warranty or additional liability.\n\nEND OF TERMS AND CONDITIONS";
    }
}

