/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.vm;

import org.reldb.rel.v0.debuginfo.DebugInfo;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.types.AttributeMap;
import org.reldb.rel.v0.types.JoinMap;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueBoolean;
import org.reldb.rel.v0.values.ValueCharacter;
import org.reldb.rel.v0.values.ValueRational;
import org.reldb.rel.v0.values.ValueRelationLiteral;
import org.reldb.rel.v0.values.ValueTuple;
import org.reldb.rel.v0.vm.Cell;
import org.reldb.rel.v0.vm.Dumper;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.NativeFunction;
import org.reldb.rel.v0.vm.NativeProcedure;
import org.reldb.rel.v0.vm.Operator;
import org.reldb.rel.v0.vm.VirtualMachine;
import org.reldb.rel.v0.vm.instructions.core.OpNop;

public class Context {
    private static final int operandstacksize = 128;
    private Instruction[] code;
    private int instructionPointer;
    private Context[] contextDisplay;
    private Cell[] variables;
    private Value[] arguments;
    private Value[] operandStack;
    private int stackPointer;
    private Context caller;
    private VirtualMachine vm;
    private Generator generator;
    private int depth;
    private boolean running = false;

    public Context(Generator generator, VirtualMachine vm) {
        this.generator = generator;
        this.vm = vm;
        this.caller = null;
        this.depth = 0;
        this.contextDisplay = new Context[this.depth + 1];
        this.contextDisplay[this.depth] = this;
        this.operandStack = new Value[128];
        this.code = null;
        this.instructionPointer = 0;
        this.stackPointer = 0;
    }

    private Context(Context caller, Operator operator, Context varparms) {
        int parmCount;
        this.generator = caller.generator;
        this.vm = caller.vm;
        this.caller = caller;
        this.depth = operator.getDepth();
        this.contextDisplay = new Context[Math.max(this.depth + 1, varparms.contextDisplay.length)];
        System.arraycopy(varparms.contextDisplay, 0, this.contextDisplay, 0, varparms.contextDisplay.length);
        this.contextDisplay[this.depth] = this;
        if (operator.getVariableCount() > 0) {
            this.variables = new Cell[operator.getVariableCount()];
        }
        if ((parmCount = operator.getParameterCount()) > 0) {
            this.arguments = new Value[parmCount];
            caller.stackPointer -= parmCount;
            System.arraycopy(caller.operandStack, caller.stackPointer, this.arguments, 0, parmCount);
        }
        this.operandStack = new Value[128];
        this.code = operator.getExecutableCode();
        this.instructionPointer = 0;
        this.stackPointer = 0;
        this.running = true;
    }

    Context(Context caller, Operator operator) {
        this(caller, operator, caller);
    }

    private void dumpstack() {
        int i;
        if (this.variables != null) {
            System.out.println("Variables:");
            i = 0;
            while (i < this.variables.length) {
                System.out.print("V[" + i + "] = ");
                if (this.variables[i] == null) {
                    System.out.println("uninitialised");
                } else {
                    System.out.println(this.variables[i]);
                }
                ++i;
            }
        }
        System.out.println("Stack:");
        i = 0;
        while (i < this.stackPointer) {
            System.out.print("S[" + i + "] = ");
            if (this.operandStack[i] == null) {
                System.out.println("uninitialised");
            } else {
                System.out.println(this.operandStack[i]);
            }
            ++i;
        }
    }

    public void dump(String prompt) {
        System.out.println("----------" + prompt + "----------");
        System.out.println("Arguments:");
        int i = 0;
        while (i <= this.depth) {
            int offset = 0;
            if (this.contextDisplay != null && this.contextDisplay[i] != null && this.contextDisplay[i].arguments != null) {
                Value[] valueArray = this.contextDisplay[i].arguments;
                int n = this.contextDisplay[i].arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    Value v = valueArray[n2];
                    System.out.println("[" + i + " " + offset++ + "] " + v);
                    ++n2;
                }
            } else {
                System.out.println("[" + i + " 0] none");
            }
            ++i;
        }
        this.dumpstack();
        System.out.println("Context ID: " + this);
        System.out.print("Depth: " + this.depth);
        new Dumper().dumpMachineCode(this.code);
        System.out.println();
        System.out.println("--------------------");
    }

    public final Instruction getCurrentInstruction() {
        if (this.code == null) {
            OpNop i = new OpNop();
            i.setDebugInfo(new DebugInfo("unknown location"));
            return i;
        }
        return this.code[this.instructionPointer - 1];
    }

    public final VirtualMachine getVirtualMachine() {
        return this.vm;
    }

    public final Generator getGenerator() {
        return this.generator;
    }

    private final void execute() {
        this.vm.setCurrentContext(this);
        while (this.instructionPointer < this.code.length && this.running) {
            this.code[this.instructionPointer++].execute(this);
        }
        this.vm.setCurrentContext(this.caller);
    }

    public void halt() {
        this.running = false;
    }

    public final void call(Operator operator) {
        new Context(this, operator).execute();
    }

    public final void call(Operator operator, Context varparmContext) {
        new Context(this, operator, varparmContext).execute();
    }

    public final void doReturn() {
        this.instructionPointer = this.code.length;
    }

    public final void doReturnValue() {
        this.caller.push(this.pop());
        this.doReturn();
    }

    public final void jump(int newIP) {
        this.instructionPointer = newIP;
    }

    public final Value peek() {
        return this.operandStack[this.stackPointer - 1];
    }

    public Value[] peek(int n) {
        Value[] values = new Value[n];
        System.arraycopy(this.operandStack, this.stackPointer - n, values, 0, n);
        return values;
    }

    final Context getCaller() {
        return this.caller;
    }

    final int getStackCount() {
        return this.stackPointer;
    }

    public final void push(Value v) {
        this.operandStack[this.stackPointer++] = v;
    }

    public final Value pop() {
        return this.operandStack[--this.stackPointer];
    }

    public final void userFunction(NativeFunction function, int parmCount) {
        Value[] arguments = new Value[parmCount];
        int i = 0;
        while (i < parmCount) {
            arguments[parmCount - i - 1] = this.pop();
            ++i;
        }
        this.push(function.evaluate(arguments));
    }

    public final void userProcedure(NativeProcedure procedure, int parmCount) {
        Value[] arguments = new Value[parmCount];
        int i = 0;
        while (i < parmCount) {
            arguments[parmCount - i - 1] = this.pop();
            ++i;
        }
        procedure.execute(arguments);
    }

    public final void parmSet(int depth, int offset) {
        this.contextDisplay[depth].arguments[offset] = this.pop();
    }

    public final void parmGet(int depth, int offset) {
        this.push(this.contextDisplay[depth].arguments[offset]);
    }

    public final void varSet(int depth, int offset) {
        this.contextDisplay[depth].variables[offset].setValue(this.generator, this.pop());
    }

    public final void varGet(int depth, int offset) {
        this.push(this.contextDisplay[depth].variables[offset].getValue(this.generator));
    }

    public final void varSetCell(int depth, int offset, Cell cell) {
        this.contextDisplay[depth].variables[offset] = cell;
    }

    public final Cell varGetCell(int depth, int offset) {
        return this.contextDisplay[depth].variables[offset];
    }

    public final void branchIfTrue(int jumpTo) {
        if (this.pop().booleanValue()) {
            this.jump(jumpTo);
        }
    }

    public final void branchIfFalse(int jumpTo) {
        if (!this.pop().booleanValue()) {
            this.jump(jumpTo);
        }
    }

    public final void pushTupleLiteral(int attributeCount) {
        this.stackPointer -= attributeCount;
        Value[] rawTuple = new Value[attributeCount];
        System.arraycopy(this.operandStack, this.stackPointer, rawTuple, 0, attributeCount);
        this.push(new ValueTuple(this.generator, rawTuple));
    }

    public final void tupleGetAttribute(int index) {
        Value[] tuple = ((ValueTuple)this.pop()).getValues();
        this.push(tuple[index]);
    }

    public final void tupleSetAttribute(int index) {
        Value[] tuple = ((ValueTuple)this.pop()).getValues();
        tuple[index] = this.pop();
        this.push(new ValueTuple(this.generator, tuple));
    }

    public final void tupleProject(AttributeMap map) {
        this.push(((ValueTuple)this.pop()).project(map));
    }

    public final void tupleJoinDisjoint() {
        Value v2 = this.pop();
        this.push(((ValueTuple)this.pop()).joinDisjoint((ValueTuple)v2));
    }

    public final void tupleJoin(JoinMap map) {
        Value v2 = this.pop();
        this.push(((ValueTuple)this.pop()).joinChecked(map, (ValueTuple)v2));
    }

    public final void relationLiteralInsertTuple() {
        ValueTuple tuple = (ValueTuple)this.pop();
        ((ValueRelationLiteral)this.peek()).insert(tuple);
    }

    public final void pushLiteral(Value literal) {
        this.push(literal);
    }

    public final void duplicate() {
        this.push(this.peek());
    }

    public final void duplicateUnder() {
        Value v = this.pop();
        this.push(this.peek());
        this.push(v);
    }

    public final void swap() {
        Value v1 = this.pop();
        Value v2 = this.pop();
        this.push(v1);
        this.push(v2);
    }

    public final void exactly(Generator generator, int countOfValues) {
        long n = this.pop().longValue();
        while (countOfValues-- > 0) {
            if (!this.pop().booleanValue()) continue;
            --n;
        }
        this.push(ValueBoolean.select(generator, n == 0L));
    }

    public final void average(Generator generator, int countOfValues) {
        double total = 0.0;
        int i = 0;
        while (i < countOfValues) {
            total += this.pop().doubleValue();
            ++i;
        }
        this.push(ValueRational.select(generator, total / (double)countOfValues));
    }

    public final void concatenate(Generator generator) {
        Value v2 = this.pop();
        this.push(ValueCharacter.select(generator, String.valueOf(this.pop().stringValue()) + v2.stringValue()));
    }
}

