/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.vm;

import java.util.HashSet;
import java.util.Vector;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.Operator;

public class Dumper {
    private HashSet<String> printed;

    public void dumpMachineCode(Instruction[] code) {
        int address = 0;
        Instruction[] instructionArray = code;
        int n = code.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction op = instructionArray[n2];
            if (op == null) {
                System.out.print("<NULL>");
            } else if (op instanceof Instruction) {
                Instruction instruction = op;
                System.out.println();
                System.out.print(String.valueOf(address) + ": " + instruction.toString());
            } else {
                System.out.print(op.toString());
            }
            ++address;
            System.out.print(" ");
            ++n2;
        }
    }

    private void dump(Operator operator) {
        System.out.print("--------" + operator.toString() + "--------");
        Vector operators = new Vector();
        if (this.printed.contains(operator.toString())) {
            return;
        }
        this.printed.add(operator.toString());
        this.dumpMachineCode(operator.getExecutableCode());
        System.out.println();
        System.out.println("-----------------");
        for (Operator code : operators) {
            this.dump(code);
        }
    }

    public void dumpMachineCode(Instruction[] code, String prompt) {
        System.out.print("--------" + prompt + "--------");
        this.dumpMachineCode(code);
        System.out.println();
        System.out.println("-----------------");
    }

    public void dumpMachineCode(Operator operator) {
        this.printed = new HashSet();
        this.dump(operator);
    }
}

