/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.vm;

import java.util.LinkedList;
import java.util.List;
import org.reldb.rel.v0.vm.Instruction;

public class Operator {
    private List<Instruction> executableCode = new LinkedList<Instruction>();
    private transient Instruction[] executableCodeCache = null;
    private int depth;
    private int varCount;
    private int parmCount;

    public Operator(int depth) {
        this.depth = depth;
    }

    public Operator(int depth, int varCount) {
        this(depth);
        this.varCount = varCount;
    }

    public void compile(Instruction op) {
        this.executableCode.add(op);
        this.executableCodeCache = null;
    }

    public void compileAt(int address, Instruction op) {
        this.executableCode.set(address, op);
        this.executableCodeCache = null;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setVariableCount(int n) {
        this.varCount = n;
    }

    public int getVariableCount() {
        return this.varCount;
    }

    public void setParameterCount(int n) {
        this.parmCount = n;
    }

    public int getParameterCount() {
        return this.parmCount;
    }

    public Instruction[] getExecutableCode() {
        if (this.executableCodeCache == null) {
            this.executableCodeCache = this.executableCode.toArray(new Instruction[0]);
        }
        return this.executableCodeCache;
    }

    public int size() {
        return this.executableCode.size();
    }

    public String toString() {
        return "\"OPERATOR\"";
    }
}

