/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.vm;

import java.io.PrintStream;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.storage.RelDatabase;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Instruction;
import org.reldb.rel.v0.vm.Operator;

public class VirtualMachine {
    private Context currentContext;
    private Context rootContext;
    private RelDatabase database;
    private Generator generator;
    private PrintStream printStream;
    private long inserts;
    private long updates;
    private long deletes;
    private boolean inserted;
    private boolean updated;
    private boolean deleted;

    public VirtualMachine(Generator generator, RelDatabase database, PrintStream printStream) {
        this.generator = generator;
        this.database = database;
        this.printStream = printStream;
        this.reset();
    }

    public void clearTupleUpdateNotices() {
        this.inserts = 0L;
        this.updates = 0L;
        this.deletes = 0L;
        this.inserted = false;
        this.updated = false;
        this.deleted = false;
    }

    public void noticeInsert(long insert) {
        this.inserts += insert;
        this.inserted = true;
    }

    public void noticeUpdate(long update) {
        this.updates += update;
        this.updated = true;
    }

    public void noticeDelete(long delete) {
        this.deletes += delete;
        this.deleted = true;
    }

    public void outputTupleUpdateNotices() {
        if (this.inserted || this.updated || this.deleted) {
            if (this.generator.isVerboseRelvarUpdates()) {
                if (this.inserted) {
                    this.printStream.println("NOTICE: Inserted " + this.inserts + " tuple" + (this.inserts == 1L ? "" : "s") + ".");
                }
                if (this.updated) {
                    this.printStream.println("NOTICE: Updated " + this.updates + " tuple" + (this.updates == 1L ? "" : "s") + ".");
                }
                if (this.deleted) {
                    this.printStream.println("NOTICE: Deleted " + this.deletes + " tuple" + (this.deletes == 1L ? "" : "s") + ".");
                }
            }
            this.clearTupleUpdateNotices();
        }
    }

    public RelDatabase getRelDatabase() {
        return this.database;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void reset() {
        Context halting = this.currentContext;
        while (halting != null) {
            halting.halt();
            halting = halting.getCaller();
        }
        this.rootContext = new Context(this.generator, this);
        this.clearTupleUpdateNotices();
    }

    public Instruction getCurrentInstruction() {
        return this.currentContext.getCurrentInstruction();
    }

    final void setCurrentContext(Context context) {
        this.currentContext = context;
    }

    public Context getCurrentContext() {
        return this.currentContext;
    }

    public final void execute(Operator op) {
        this.rootContext.call(op);
    }

    public final Value pop() {
        return this.rootContext.pop();
    }

    public final int getStackCount() {
        return this.rootContext.getStackCount();
    }
}

