/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.vm.instructions.core;

import java.util.HashSet;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.generator.OperatorDefinition;
import org.reldb.rel.v0.generator.OperatorSignature;
import org.reldb.rel.v0.types.Type;
import org.reldb.rel.v0.values.Value;
import org.reldb.rel.v0.values.ValueAlpha;
import org.reldb.rel.v0.vm.Context;

abstract class DynamicDispatch {
    private Generator generator;
    private OperatorSignature invocationSignature;
    private OperatorDefinition inOperator;

    DynamicDispatch(Generator generator, OperatorSignature invocationSignature, OperatorDefinition inOperator) {
        this.generator = generator;
        this.invocationSignature = invocationSignature;
        this.inOperator = inOperator;
    }

    void locateAndInvoke(Context context) {
        Value[] operands = context.peek(this.invocationSignature.getParmCount());
        int i = 0;
        while (i < this.invocationSignature.getParmCount()) {
            if (operands[i] instanceof ValueAlpha) {
                Type argumentType = ((ValueAlpha)operands[i]).getType(this.generator.getDatabase());
                this.invocationSignature.setParameterType(i, argumentType);
            }
            ++i;
        }
        HashSet<OperatorSignature> possibleTargets = this.generator.getPossibleTargetSignatures(this.inOperator, this.invocationSignature);
        if (possibleTargets.size() == 0) {
            throw new ExceptionSemantic("RS0278: No run-time invocation targets found for " + this.invocationSignature);
        }
        int closestDistance = Integer.MAX_VALUE;
        OperatorSignature closestSignature = null;
        for (OperatorSignature signature : possibleTargets) {
            int distance = signature.getInvocationDistance(this.invocationSignature);
            if (distance > closestDistance) continue;
            closestDistance = distance;
            closestSignature = signature;
        }
        OperatorDefinition operator = this.generator.locateOperator(this.inOperator, closestSignature);
        if (operator != null) {
            this.invoke(operator, context);
            return;
        }
        throw new ExceptionSemantic("RS0279: Operator '" + closestSignature + "' has not been defined, nor has any compatible operator of the same name.");
    }

    abstract void invoke(OperatorDefinition var1, Context var2);
}

