/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.v0.vm.instructions.relvar;

import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.v0.storage.relvars.RelvarGlobal;
import org.reldb.rel.v0.storage.relvars.RelvarHeading;
import org.reldb.rel.v0.types.Heading;
import org.reldb.rel.v0.vm.Context;
import org.reldb.rel.v0.vm.Instruction;

public final class OpRelvarGlobalGet
extends Instruction {
    private Heading definedHeading;
    private String relvarName;

    public OpRelvarGlobalGet(String relvarName, RelvarHeading headingDefinition) {
        this.relvarName = relvarName;
        this.definedHeading = headingDefinition.getHeading();
    }

    @Override
    public final void execute(Context context) {
        RelvarGlobal relvar = context.getVirtualMachine().getRelDatabase().openGlobalRelvar(this.relvarName);
        if (relvar == null) {
            throw new ExceptionSemantic("RS0281: Relation-valued variable " + this.relvarName + " no longer exists.");
        }
        if (!this.definedHeading.canAccept(relvar.getHeadingDefinition().getHeading())) {
            throw new ExceptionSemantic("RS0282: Relation-valued variable " + this.relvarName + " has heading " + relvar.getHeadingDefinition().getHeading() + " but " + this.definedHeading + " was expected.");
        }
        context.push(relvar.getValue(context.getGenerator()));
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + " " + this.relvarName;
    }
}

