/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.junit.runner.JUnitCore;
import org.reldb.rel.tests.ClassPathHack;
import org.reldb.rel.v0.version.Version;

public class AllTests {
    private static final String[] tests = new String[]{"org.reldb.rel.tests.main", "org.reldb.rel.tests.external", "org.reldb.rel.tests.inheritance"};

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(AllTests.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class")) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            ++n2;
        }
        return classes;
    }

    private static List<Class<?>> getClassesFromDirectory(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(AllTests.findClasses(directory, packageName));
        }
        return classes;
    }

    private static List<Class<?>> getClassesFromJAR(URL jarURL, String packageName) throws ClassNotFoundException, IOException {
        ArrayList classes = new ArrayList();
        ZipInputStream jar = new ZipInputStream(jarURL.openStream());
        ZipEntry ze = null;
        while ((ze = jar.getNextEntry()) != null) {
            String entryName = ze.getName().replace('/', '.');
            if (!entryName.startsWith(packageName) || !entryName.endsWith(".class")) continue;
            String className = entryName.substring(0, entryName.length() - 6);
            classes.add(Class.forName(className));
        }
        return classes;
    }

    private static List<Class<?>> getClasses(URL jar, String packageName) throws ClassNotFoundException, IOException {
        if (jar == null) {
            return AllTests.getClassesFromDirectory(packageName);
        }
        return AllTests.getClassesFromJAR(jar, packageName);
    }

    private static ArrayList<String> getClassNames(URL jar, String packageName) throws ClassNotFoundException, IOException {
        List<Class<?>> classes = AllTests.getClasses(jar, packageName);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> klass : classes) {
            names.add(klass.getName());
        }
        return names;
    }

    public static void main(String[] args) {
        try {
            ClassPathHack.addFile("rel0000.jar");
            ClassPathHack.addFile("relshared.jar");
            ClassPathHack.addFile(Version.getBerkeleyDbJarFilename());
            ClassPathHack.addFile("junit.jar");
            ClassPathHack.addFile("ecj-4.4.2.jar");
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            return;
        }
        ArrayList<String> classes = new ArrayList<String>();
        try {
            CodeSource src = AllTests.class.getProtectionDomain().getCodeSource();
            URL jarURL = null;
            if (src != null && src.getLocation().toString().toUpperCase().endsWith(".JAR")) {
                jarURL = src.getLocation();
            }
            String[] stringArray = tests;
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                String testMe = stringArray[n2];
                classes.addAll(AllTests.getClassNames(jarURL, testMe));
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        System.out.println("Rel tests are running.  Please wait.");
        JUnitCore.main((String[])classes.toArray(new String[0]));
    }
}

