/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.tests;

import java.io.PrintStream;
import org.junit.Assert;
import org.reldb.rel.exceptions.DatabaseFormatVersionException;
import org.reldb.rel.exceptions.ExceptionFatal;
import org.reldb.rel.exceptions.ExceptionSemantic;
import org.reldb.rel.tests.StringStream;
import org.reldb.rel.v0.generator.Generator;
import org.reldb.rel.v0.interpreter.Evaluation;
import org.reldb.rel.v0.interpreter.Instance;
import org.reldb.rel.v0.interpreter.Interpreter;
import org.reldb.rel.v0.languages.tutoriald.parser.ParseException;
import org.reldb.rel.v0.values.Value;

public class BaseOfTest {
    protected static Instance instance = BaseOfTest.getInstance();
    protected static Interpreter interpreter = new Interpreter(instance.getDatabase(), System.out);
    protected static Generator generator = interpreter.getGenerator();

    protected static Instance getInstance() {
        try {
            return new Instance("./", true, System.out);
        }
        catch (DatabaseFormatVersionException e) {
            throw new ExceptionFatal("Database already exists and is in an older format.");
        }
    }

    protected static Evaluation testEvaluate(String s) {
        try {
            return interpreter.evaluate(s);
        }
        catch (ParseException pe) {
            throw new ExceptionSemantic("BaseOfTest: " + (Object)((Object)pe));
        }
    }

    public static void assertValueEquals(Value v1, Value v2) {
        Assert.assertEquals((long)v1.compareTo(v2), (long)0L);
    }

    protected static void testEquals(String expected, String src) {
        Evaluation v = BaseOfTest.testEvaluate(src);
        StringStream stringStream = new StringStream();
        v.toStream((PrintStream)stringStream);
        Assert.assertEquals((Object)expected, (Object)((Object)stringStream).toString());
    }
}

