/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.tests.main;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.reldb.rel.tests.BaseOfTest;

public class TestAggregate
extends BaseOfTest {
    @BeforeClass
    public static void testAggregateSetup() {
        String src = "begin;  VAR myvar REAL RELATION {x INT} KEY {x};  myvar := RELATION {\tTUPLE {x 1},\tTUPLE {x 2},\tTUPLE {x 3},\tTUPLE {x 4},\tTUPLE {x 5},\tTUPLE {x 6}  };end;true";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate00() {
        String src = "SUM(myvar, x)";
        String expected = "21";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate01() {
        String src = "SUM(myvar, x) = AGGREGATE(myvar, x); RETURN VALUE1 + VALUE2; END AGGREGATE";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate02() {
        String src = "SUM(myvar, x * 10) = AGGREGATE(myvar, x * 10); RETURN VALUE1 + VALUE2; END AGGREGATE";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate03() {
        String src = "COUNT(myvar) = 6";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate04() {
        String src = "COUNT(REL {x INT} {}) = 0";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate05() {
        String src = "COUNT(REL {x INT} {}) = AGGREGATE(REL {x INT} {}, 1, 0); RETURN VALUE1 + VALUE2; END AGGREGATE";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate06() {
        String src = "COUNT(myvar) = AGGREGATE(myvar, 1, 0); RETURN VALUE1 + VALUE2; END AGGREGATE";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate07() {
        String src = "arithmeticMean FROM TUPLE FROM EXTEND \tSUMMARIZE myvar:  \t{ \t\ttotal := AGGREGATE(x); RETURN VALUE1 + VALUE2; END AGGREGATE, \t\tN := AGGREGATE(1); RETURN VALUE1 + VALUE2; END AGGREGATE \t} : {arithmeticMean := CAST_AS_RATIONAL(total) / CAST_AS_RATIONAL(N)} ";
        String expected = "3.5";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregate08() {
        String src = "arithmeticMean FROM TUPLE FROM EXTEND \tSUMMARIZE myvar:  \t{ \t\ttotal := AGGREGATE(x, 0); RETURN VALUE1 + VALUE2; END AGGREGATE, \t\tN := AGGREGATE(1, 0); RETURN VALUE1 + VALUE2; END AGGREGATE \t} : {arithmeticMean := CAST_AS_RATIONAL(total) / CAST_AS_RATIONAL(N)} ";
        String expected = "3.5";
        TestAggregate.testEquals(expected, src);
    }

    @Test
    public void testAggregateDistinctAgainstSumDistinct() {
        String src = "BEGIN;\nVAR a PRIVATE INIT(relation {\n       tuple {x 1, y 4.5, z \"test\"},\n       tuple {x 2, y 2.5, z \"test\"},\n       tuple {x 3, y 3.2, z \"glub\"},\n       tuple {x 4, y 4.5, z \"glub\"},\n       tuple {x 5, y 5.2, z \"test\"},\n       tuple {x 6, y 3.1, z \"zot\"},\n       tuple {x 7, y 4.5, z \"test\"}\n}) KEY {ALL BUT};\nEND;\nSUMMARIZE a PER (a {z}) : {totalOfxSUMD := SUMD(x), totalOfxAGGREGATED := AGGREGATED(x); RETURN VALUE1 + VALUE2; END AGGREGATED}";
        TestAggregate.testEquals("RELATION {z CHARACTER, totalOfxSUMD INTEGER, totalOfxAGGREGATED INTEGER} {\n\tTUPLE {z \"test\", totalOfxSUMD 15, totalOfxAGGREGATED 15},\n\tTUPLE {z \"glub\", totalOfxSUMD 7, totalOfxAGGREGATED 7},\n\tTUPLE {z \"zot\", totalOfxSUMD 6, totalOfxAGGREGATED 6}\n}", src);
    }

    @AfterClass
    public static void testSummarizeComplexTeardown() {
        String src = "begin;  DROP VAR myvar;end;true";
        String expected = "true";
        TestAggregate.testEquals(expected, src);
    }
}

