/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.RecoveryUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.CheckpointFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.INFileReader;
import com.sleepycat.je.log.LNFileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.recovery.CheckpointEnd;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RollbackTracker;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.PreparedTxn;
import com.sleepycat.je.txn.RollbackEnd;
import com.sleepycat.je.txn.RollbackStart;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecoveryManager {
    private static final String TRACE_LN_REDO = "LNRedo:";
    private static final String TRACE_LN_UNDO = "LNUndo";
    private static final String TRACE_IN_REPLACE = "INRecover:";
    private static final String TRACE_ROOT_REPLACE = "RootRecover:";
    private static final String TRACE_ROOT_DELETE = "RootDelete:";
    private final EnvironmentImpl envImpl;
    private final int readBufferSize;
    private final RecoveryInfo info;
    private final Map<Long, Long> committedTxnIds;
    private final Set<Long> abortedTxnIds;
    private Map<Long, PreparedTxn> preparedTxns;
    private Set<Long> resurrectedLsns;
    private final Set<DatabaseId> inListBuildDbIds;
    private final Set<DatabaseId> tempDbIds;
    private final Set<DatabaseId> expectDeletedMapLNs;
    private final RollbackTracker rollbackTracker;
    private final RecoveryUtilizationTracker tracker;
    private final StartupTracker startupTracker;
    private final Logger logger;
    private final Set<DatabaseId> logVersion8UpgradeDbs;
    private final AtomicBoolean logVersion8UpgradeDeltas;

    public RecoveryManager(EnvironmentImpl env) throws DatabaseException {
        this.envImpl = env;
        DbConfigManager cm = env.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.committedTxnIds = new HashMap<Long, Long>();
        this.abortedTxnIds = new HashSet<Long>();
        this.preparedTxns = new HashMap<Long, PreparedTxn>();
        this.resurrectedLsns = new HashSet<Long>();
        this.inListBuildDbIds = new HashSet<DatabaseId>();
        this.tempDbIds = new HashSet<DatabaseId>();
        this.expectDeletedMapLNs = new HashSet<DatabaseId>();
        this.tracker = new RecoveryUtilizationTracker(env);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.rollbackTracker = new RollbackTracker(this.envImpl);
        this.info = new RecoveryInfo();
        this.logVersion8UpgradeDbs = new HashSet<DatabaseId>();
        this.logVersion8UpgradeDeltas = new AtomicBoolean(false);
        this.startupTracker = this.envImpl.getStartupTracker();
        this.startupTracker.setRecoveryInfo(this.info);
    }

    public RecoveryInfo recover(boolean readOnly) throws DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.TOTAL_RECOVERY);
        try {
            EnvironmentConfig envConfig;
            boolean forceCheckpoint;
            FileManager fileManager = this.envImpl.getFileManager();
            DbConfigManager configManager = this.envImpl.getConfigManager();
            if (configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_NEW_FILE)) {
                fileManager.forceNewLogFile();
                forceCheckpoint = true;
            } else {
                forceCheckpoint = configManager.getBoolean(EnvironmentParams.ENV_RECOVERY_FORCE_CHECKPOINT);
            }
            if (fileManager.filesExist()) {
                fileManager.getAllFileNumbers();
                this.findEndOfLog(readOnly);
                String endOfLogMsg = "Recovery underway, found end of log";
                Trace.traceLazily(this.envImpl, endOfLogMsg);
                this.findLastCheckpoint();
                this.envImpl.getLogManager().setLastLsnAtRecovery(fileManager.getLastUsedLsn());
                this.envImpl.readMapTreeFromLog(this.info.useRootLsn);
                this.buildTree();
            } else {
                LoggerUtils.logMsg(this.logger, this.envImpl, Level.CONFIG, "Recovery w/no files.");
                this.envImpl.getInMemoryINs().enable();
                this.envImpl.getEvictor().setEnabled(true);
                if (!readOnly) {
                    this.envImpl.logMapTreeRoot();
                }
                if (this.envImpl.getSharedCache()) {
                    this.envImpl.getEvictor().addEnvironment(this.envImpl);
                }
                forceCheckpoint = true;
            }
            int ptSize = this.preparedTxns.size();
            if (ptSize > 0) {
                boolean singular = ptSize == 1;
                LoggerUtils.logMsg(this.logger, this.envImpl, Level.INFO, "There " + (singular ? "is " : "are ") + ptSize + " prepared but unfinished " + (singular ? "txn." : "txns."));
                this.preparedTxns = null;
            }
            if (DbInternal.getCreateUP(envConfig = this.envImpl.getConfigManager().getEnvironmentConfig())) {
                this.startupTracker.start(StartupTracker.Phase.POPULATE_UP);
                this.startupTracker.setProgress(RecoveryProgress.POPULATE_UTILIZATION_PROFILE);
                this.envImpl.getUtilizationProfile().populateCache(this.startupTracker.getCounter(StartupTracker.Phase.POPULATE_UP));
                this.startupTracker.stop(StartupTracker.Phase.POPULATE_UP);
            }
            if (DbInternal.getCreateEP(envConfig)) {
                this.startupTracker.start(StartupTracker.Phase.POPULATE_EP);
                this.startupTracker.setProgress(RecoveryProgress.POPULATE_EXPIRATION_PROFILE);
                this.envImpl.getExpirationProfile().populateCache(this.startupTracker.getCounter(StartupTracker.Phase.POPULATE_EP), this.envImpl.getRecoveryProgressListener());
                this.startupTracker.stop(StartupTracker.Phase.POPULATE_EP);
            }
            this.tracker.transferToUtilizationTracker(this.envImpl.getUtilizationTracker());
            this.removeTempDbs();
            this.deleteMapLNs();
            this.envImpl.preRecoveryCheckpointInit(this.info);
            if (!readOnly && (this.envImpl.getLogManager().getLastLsnAtRecovery() != this.info.checkpointEndLsn || forceCheckpoint)) {
                CheckpointConfig config = new CheckpointConfig();
                config.setForce(true);
                config.setMinimizeRecoveryTime(true);
                this.startupTracker.setProgress(RecoveryProgress.CKPT);
                this.startupTracker.start(StartupTracker.Phase.CKPT);
                this.envImpl.invokeCheckpoint(config, "recovery");
                this.startupTracker.setStats(StartupTracker.Phase.CKPT, this.envImpl.getCheckpointer().loadStats(StatsConfig.DEFAULT));
                this.startupTracker.stop(StartupTracker.Phase.CKPT);
            } else {
                this.envImpl.getCheckpointer().initIntervals(this.info.checkpointStartLsn, this.info.checkpointEndLsn, System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            LoggerUtils.traceAndLogException(this.envImpl, "RecoveryManager", "recover", "Couldn't recover", e);
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_READ, (Throwable)e);
        }
        finally {
            this.startupTracker.stop(StartupTracker.Phase.TOTAL_RECOVERY);
        }
        return this.info;
    }

    private void findEndOfLog(boolean readOnly) throws IOException, DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.FIND_END_OF_LOG);
        this.startupTracker.setProgress(RecoveryProgress.FIND_END_OF_LOG);
        StartupTracker.Counter counter = this.startupTracker.getCounter(StartupTracker.Phase.FIND_END_OF_LOG);
        LastFileReader reader = new LastFileReader(this.envImpl, this.readBufferSize);
        while (reader.readNextEntry()) {
            counter.incNumRead();
            counter.incNumProcessed();
            LogEntryType type = reader.getEntryType();
            if (LogEntryType.LOG_CKPT_END.equals(type)) {
                this.info.checkpointEndLsn = reader.getLastLsn();
                this.info.partialCheckpointStartLsn = -1L;
                continue;
            }
            if (LogEntryType.LOG_CKPT_START.equals(type)) {
                if (this.info.partialCheckpointStartLsn != -1L) continue;
                this.info.partialCheckpointStartLsn = reader.getLastLsn();
                continue;
            }
            if (LogEntryType.LOG_DBTREE.equals(type)) {
                this.info.useRootLsn = reader.getLastLsn();
                continue;
            }
            if (!LogEntryType.LOG_IMMUTABLE_FILE.equals(type)) continue;
            this.envImpl.getFileManager().forceNewLogFile();
        }
        assert (reader.getLastValidLsn() != reader.getEndOfLog()) : "lastUsed=" + DbLsn.getNoFormatString(reader.getLastValidLsn()) + " end=" + DbLsn.getNoFormatString(reader.getEndOfLog());
        if (!readOnly) {
            reader.setEndOfFile();
        }
        this.info.lastUsedLsn = reader.getLastValidLsn();
        this.info.nextAvailableLsn = reader.getEndOfLog();
        counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        this.envImpl.getFileManager().setLastPosition(this.info.nextAvailableLsn, this.info.lastUsedLsn, reader.getPrevOffset());
        this.startupTracker.stop(StartupTracker.Phase.FIND_END_OF_LOG);
    }

    private void findLastCheckpoint() throws IOException, DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.FIND_LAST_CKPT);
        this.startupTracker.setProgress(RecoveryProgress.FIND_LAST_CKPT);
        StartupTracker.Counter counter = this.startupTracker.getCounter(StartupTracker.Phase.FIND_LAST_CKPT);
        if (this.info.checkpointEndLsn == -1L) {
            CheckpointFileReader searcher = new CheckpointFileReader(this.envImpl, this.readBufferSize, false, this.info.lastUsedLsn, -1L, this.info.nextAvailableLsn);
            while (searcher.readNextEntry()) {
                counter.incNumRead();
                counter.incNumProcessed();
                if (searcher.isCheckpointEnd()) {
                    this.info.checkpointEndLsn = searcher.getLastLsn();
                    break;
                }
                if (searcher.isCheckpointStart()) {
                    this.info.partialCheckpointStartLsn = searcher.getLastLsn();
                    continue;
                }
                if (!searcher.isDbTree() || this.info.useRootLsn != -1L) continue;
                this.info.useRootLsn = searcher.getLastLsn();
            }
            counter.setRepeatIteratorReads(searcher.getNRepeatIteratorReads());
        }
        if (this.info.checkpointEndLsn == -1L) {
            this.info.checkpointStartLsn = -1L;
            this.info.firstActiveLsn = -1L;
        } else {
            CheckpointEnd checkpointEnd;
            this.info.checkpointEnd = checkpointEnd = (CheckpointEnd)this.envImpl.getLogManager().getEntry(this.info.checkpointEndLsn);
            this.info.checkpointStartLsn = checkpointEnd.getCheckpointStartLsn();
            this.info.firstActiveLsn = checkpointEnd.getFirstActiveLsn();
            if (checkpointEnd.getRootLsn() != -1L && this.info.useRootLsn == -1L) {
                this.info.useRootLsn = checkpointEnd.getRootLsn();
            }
            this.envImpl.getCheckpointer().setCheckpointId(checkpointEnd.getId());
        }
        this.rollbackTracker.setCheckpointStart(this.info.checkpointStartLsn);
        this.startupTracker.stop(StartupTracker.Phase.FIND_LAST_CKPT);
        if (this.info.useRootLsn == -1L) {
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "This environment's log file has no root. Since the root is the first entry written into a log at environment creation, this should only happen if the initial creation of the environment was never checkpointed or synced. Please move aside the existing log files to allow the creation of a new environment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTree() throws DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.BUILD_TREE);
        try {
            this.buildINs(true, StartupTracker.Phase.READ_MAP_INS, StartupTracker.Phase.REDO_MAP_INS, RecoveryProgress.READ_DBMAP_INFO, RecoveryProgress.REDO_DBMAP_INFO);
            this.startupTracker.start(StartupTracker.Phase.UNDO_MAP_LNS);
            this.startupTracker.setProgress(RecoveryProgress.UNDO_DBMAP_RECORDS);
            HashSet<LogEntryType> mapLNSet = new HashSet<LogEntryType>();
            mapLNSet.add(LogEntryType.LOG_TXN_COMMIT);
            mapLNSet.add(LogEntryType.LOG_TXN_ABORT);
            mapLNSet.add(LogEntryType.LOG_TXN_PREPARE);
            mapLNSet.add(LogEntryType.LOG_ROLLBACK_START);
            mapLNSet.add(LogEntryType.LOG_ROLLBACK_END);
            this.undoLNs(mapLNSet, true, this.startupTracker.getCounter(StartupTracker.Phase.UNDO_MAP_LNS));
            this.startupTracker.stop(StartupTracker.Phase.UNDO_MAP_LNS);
            this.envImpl.getFileManager().startFileCacheWarmer(this.info.firstActiveLsn);
            this.startupTracker.start(StartupTracker.Phase.REDO_MAP_LNS);
            this.startupTracker.setProgress(RecoveryProgress.REDO_DBMAP_RECORDS);
            mapLNSet.clear();
            mapLNSet.add(LogEntryType.LOG_MAPLN);
            this.redoLNs(mapLNSet, this.startupTracker.getCounter(StartupTracker.Phase.REDO_MAP_LNS));
            this.startupTracker.stop(StartupTracker.Phase.REDO_MAP_LNS);
            this.checkLogVersion8UpgradeViolations();
            this.buildINs(false, StartupTracker.Phase.READ_INS, StartupTracker.Phase.REDO_INS, RecoveryProgress.READ_DATA_INFO, RecoveryProgress.REDO_DATA_INFO);
            this.buildINList();
            if (this.envImpl.getSharedCache()) {
                this.envImpl.getEvictor().addEnvironment(this.envImpl);
            }
            this.envImpl.invokeEvictor();
            this.startupTracker.start(StartupTracker.Phase.UNDO_LNS);
            this.startupTracker.setProgress(RecoveryProgress.UNDO_DATA_RECORDS);
            HashSet<LogEntryType> lnSet = new HashSet<LogEntryType>();
            for (LogEntryType entryType : LogEntryType.getAllTypes()) {
                if (!entryType.isUserLNType() || !entryType.isTransactional()) continue;
                lnSet.add(entryType);
            }
            lnSet.add(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
            this.undoLNs(lnSet, false, this.startupTracker.getCounter(StartupTracker.Phase.UNDO_LNS));
            this.startupTracker.stop(StartupTracker.Phase.UNDO_LNS);
            this.startupTracker.start(StartupTracker.Phase.REDO_LNS);
            this.startupTracker.setProgress(RecoveryProgress.REDO_DATA_RECORDS);
            for (LogEntryType entryType : LogEntryType.getAllTypes()) {
                if (!entryType.isUserLNType() || entryType.isTransactional()) continue;
                lnSet.add(entryType);
            }
            lnSet.add(LogEntryType.LOG_NAMELN);
            lnSet.add(LogEntryType.LOG_FILESUMMARYLN);
            this.redoLNs(lnSet, this.startupTracker.getCounter(StartupTracker.Phase.REDO_LNS));
            this.startupTracker.stop(StartupTracker.Phase.REDO_LNS);
            this.rollbackTracker.recoveryEndFsyncInvisible();
        }
        finally {
            this.startupTracker.stop(StartupTracker.Phase.BUILD_TREE);
        }
    }

    private void buildINs(boolean mappingTree, StartupTracker.Phase phaseA, StartupTracker.Phase phaseB, RecoveryProgress progressA, RecoveryProgress progressB) throws DatabaseException {
        this.startupTracker.start(phaseA);
        this.startupTracker.setProgress(progressA);
        if (mappingTree) {
            this.readRootINsAndTrackIds(this.startupTracker.getCounter(phaseA));
        } else {
            this.readRootINs(this.startupTracker.getCounter(phaseA));
        }
        this.startupTracker.stop(phaseA);
        this.startupTracker.start(phaseB);
        this.startupTracker.setProgress(progressB);
        this.readNonRootINs(mappingTree, this.startupTracker.getCounter(phaseB));
        this.startupTracker.stop(phaseB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRootINsAndTrackIds(StartupTracker.Counter counter) throws DatabaseException {
        INFileReader reader = new INFileReader(this.envImpl, this.readBufferSize, this.info.checkpointStartLsn, this.info.nextAvailableLsn, true, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, this.tracker, this.logVersion8UpgradeDbs, this.logVersion8UpgradeDeltas);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.setAlwaysValidateChecksum(true);
        try {
            DbTree dbMapTree = this.envImpl.getDbTree();
            while (reader.readNextEntry()) {
                counter.incNumRead();
                DatabaseId dbId = reader.getDatabaseId();
                if (!dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                assert (db != null);
                try {
                    if (!reader.getIN(db).isRoot()) continue;
                    this.replayOneIN(reader, db);
                    counter.incNumProcessed();
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
            this.info.useMinReplicatedNodeId = reader.getMinReplicatedNodeId();
            this.info.useMaxNodeId = reader.getMaxNodeId();
            this.info.useMinReplicatedDbId = reader.getMinReplicatedDbId();
            this.info.useMaxDbId = reader.getMaxDbId();
            this.info.useMinReplicatedTxnId = reader.getMinReplicatedTxnId();
            this.info.useMaxTxnId = reader.getMaxTxnId();
            if (this.info.checkpointEnd != null) {
                CheckpointEnd ckptEnd = this.info.checkpointEnd;
                if (this.info.useMinReplicatedNodeId > ckptEnd.getLastReplicatedNodeId()) {
                    this.info.useMinReplicatedNodeId = ckptEnd.getLastReplicatedNodeId();
                }
                if (this.info.useMaxNodeId < ckptEnd.getLastLocalNodeId()) {
                    this.info.useMaxNodeId = ckptEnd.getLastLocalNodeId();
                }
                if (this.info.useMinReplicatedDbId > ckptEnd.getLastReplicatedDbId()) {
                    this.info.useMinReplicatedDbId = ckptEnd.getLastReplicatedDbId();
                }
                if (this.info.useMaxDbId < ckptEnd.getLastLocalDbId()) {
                    this.info.useMaxDbId = ckptEnd.getLastLocalDbId();
                }
                if (this.info.useMinReplicatedTxnId > ckptEnd.getLastReplicatedTxnId()) {
                    this.info.useMinReplicatedTxnId = ckptEnd.getLastReplicatedTxnId();
                }
                if (this.info.useMaxTxnId < ckptEnd.getLastLocalTxnId()) {
                    this.info.useMaxTxnId = ckptEnd.getLastLocalTxnId();
                }
            }
            this.envImpl.getNodeSequence().setLastNodeId(this.info.useMinReplicatedNodeId, this.info.useMaxNodeId);
            this.envImpl.getDbTree().setLastDbId(this.info.useMinReplicatedDbId, this.info.useMaxDbId);
            this.envImpl.getTxnManager().setLastTxnId(this.info.useMinReplicatedTxnId, this.info.useMaxTxnId);
            this.info.vlsnProxy = reader.getVLSNProxy();
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readMapIns", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRootINs(StartupTracker.Counter counter) throws DatabaseException {
        INFileReader reader = new INFileReader(this.envImpl, this.readBufferSize, this.info.checkpointStartLsn, this.info.nextAvailableLsn, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, null);
        reader.addTargetType(LogEntryType.LOG_IN);
        try {
            DbTree dbMapTree = this.envImpl.getDbTree();
            while (reader.readNextEntry()) {
                counter.incNumRead();
                DatabaseId dbId = reader.getDatabaseId();
                if (dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                if (db == null) {
                    counter.incNumDeleted();
                    continue;
                }
                try {
                    if (!reader.getIN(db).isRoot()) continue;
                    this.replayOneIN(reader, db);
                    counter.incNumProcessed();
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNonRootINs(boolean mappingTree, StartupTracker.Counter counter) throws DatabaseException {
        INFileReader reader = new INFileReader(this.envImpl, this.readBufferSize, this.info.checkpointStartLsn, this.info.nextAvailableLsn, false, this.info.partialCheckpointStartLsn, this.info.checkpointEndLsn, null);
        reader.addTargetType(LogEntryType.LOG_IN);
        reader.addTargetType(LogEntryType.LOG_BIN);
        reader.addTargetType(LogEntryType.LOG_BIN_DELTA);
        reader.addTargetType(LogEntryType.LOG_OLD_BIN_DELTA);
        try {
            DbTree dbMapTree = this.envImpl.getDbTree();
            while (reader.readNextEntry()) {
                counter.incNumRead();
                DatabaseId dbId = reader.getDatabaseId();
                if (mappingTree != dbId.equals(DbTree.ID_DB_ID)) continue;
                DatabaseImpl db = dbMapTree.getDb(dbId);
                if (db == null) {
                    counter.incNumDeleted();
                    continue;
                }
                try {
                    if (reader.getIN(db).isRoot()) continue;
                    this.replayOneIN(reader, db);
                    counter.incNumProcessed();
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "readNonMapIns", e);
        }
    }

    private void replayOneIN(INFileReader reader, DatabaseImpl db) throws DatabaseException {
        long logLsn = reader.getLastLsn();
        IN in = reader.getIN(db);
        in.postRecoveryInit(db, logLsn);
        in.latch();
        this.recoverIN(db, in, logLsn);
        this.inListBuildDbIds.add(db.getId());
    }

    private void recoverIN(DatabaseImpl db, IN inFromLog, long logLsn) throws DatabaseException {
        ArrayList<TrackingInfo> trackingList = null;
        try {
            if (inFromLog.isRoot()) {
                this.recoverRootIN(db, inFromLog, logLsn);
            } else {
                trackingList = new ArrayList<TrackingInfo>();
                this.recoverChildIN(db, inFromLog, logLsn, trackingList);
            }
        }
        catch (EnvironmentFailureException e) {
            throw e;
        }
        catch (Exception e) {
            String trace = this.printTrackList(trackingList);
            LoggerUtils.traceAndLogException(db.getEnv(), "RecoveryManager", "recoverIN", " lsnFromLog: " + DbLsn.getNoFormatString(logLsn) + " " + trace, e);
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "lsnFromLog=" + DbLsn.getNoFormatString(logLsn), e);
        }
        finally {
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0, "LSN = " + DbLsn.toString(logLsn) + " inFromLog = " + inFromLog.getNodeId());
            }
        }
    }

    private void recoverRootIN(DatabaseImpl db, IN inFromLog, long lsn) throws DatabaseException {
        boolean success = true;
        Tree tree = db.getTree();
        RootUpdater rootUpdater = new RootUpdater(tree, inFromLog, lsn);
        try {
            tree.withRootLatchedExclusive(rootUpdater);
            if (rootUpdater.updateDone()) {
                db.setDirty();
            }
        }
        catch (Exception e) {
            success = false;
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "lsnFromLog=" + DbLsn.getNoFormatString(lsn), e);
        }
        finally {
            if (rootUpdater.getInFromLogIsLatched()) {
                inFromLog.releaseLatch();
            }
            RecoveryManager.trace(this.logger, db, TRACE_ROOT_REPLACE, success, inFromLog, lsn, null, true, rootUpdater.getReplaced(), rootUpdater.getInserted(), rootUpdater.getOriginalLsn(), -1L, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverChildIN(DatabaseImpl db, IN inFromLog, long logLsn, List<TrackingInfo> trackingList) throws DatabaseException {
        boolean inserted = false;
        boolean replaced = false;
        long treeLsn = -1L;
        boolean finished = false;
        SearchResult result = new SearchResult();
        try {
            long targetNodeId = inFromLog.getNodeId();
            byte[] targetKey = inFromLog.getIdentifierKey();
            int exclusiveLevel = inFromLog.getLevel() + 1;
            inFromLog.releaseLatch();
            result = db.getTree().getParentINForChildIN(targetNodeId, targetKey, -1, exclusiveLevel, true, true, CacheMode.UNCHANGED, trackingList);
            if (result.parent == null) {
                finished = true;
                return;
            }
            IN parent = result.parent;
            int idx = result.index;
            assert (result.exactParentFound);
            assert (result.index >= 0);
            assert (targetNodeId == ((IN)parent.getTarget(idx)).getNodeId());
            if (parent.getLsn(idx) != logLsn && DbLsn.compareTo(treeLsn = parent.getLsn(idx), logLsn) < 0) {
                parent.recoverIN(idx, inFromLog, logLsn, 0);
                replaced = true;
            }
            finished = true;
        }
        finally {
            if (result.parent != null) {
                result.parent.releaseLatch();
            }
            RecoveryManager.trace(this.logger, db, TRACE_IN_REPLACE, finished, inFromLog, logLsn, result.parent, result.exactParentFound, replaced, inserted, treeLsn, -1L, result.index);
        }
    }

    private void undoLNs(Set<LogEntryType> logTypes, boolean firstUndoPass, StartupTracker.Counter counter) throws DatabaseException {
        long firstActiveLsn = this.info.firstActiveLsn;
        long lastUsedLsn = this.info.lastUsedLsn;
        long endOfFileLsn = this.info.nextAvailableLsn;
        LNFileReader reader = new LNFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, false, endOfFileLsn, firstActiveLsn, null, this.info.checkpointEndLsn);
        for (LogEntryType lt : logTypes) {
            reader.addTargetType(lt);
        }
        DbTree dbMapTree = this.envImpl.getDbTree();
        this.rollbackTracker.setFirstPass(firstUndoPass);
        RollbackTracker.Scanner rollbackScanner = this.rollbackTracker.getScanner();
        try {
            while (reader.readNextEntry()) {
                counter.incNumRead();
                if (reader.isLN()) {
                    Long txnId = reader.getTxnId();
                    if (txnId == null) continue;
                    if (rollbackScanner.positionAndCheck(reader.getLastLsn(), txnId)) {
                        rollbackScanner.rollback(txnId, reader, this.tracker);
                        continue;
                    }
                    if (this.committedTxnIds.containsKey(txnId)) continue;
                    if (this.preparedTxns.get(txnId) != null) {
                        this.resurrectedLsns.add(reader.getLastLsn());
                        continue;
                    }
                    if (this.isReplicatedUncommittedLN(reader, txnId)) {
                        this.createReplayTxn(txnId);
                        this.resurrectedLsns.add(reader.getLastLsn());
                        continue;
                    }
                    this.undoUncommittedLN(reader, dbMapTree);
                    counter.incNumProcessed();
                    continue;
                }
                if (reader.isPrepare()) {
                    this.handlePrepare(reader);
                    counter.incNumAux();
                    continue;
                }
                if (reader.isAbort()) {
                    this.abortedTxnIds.add(reader.getTxnAbortId());
                    counter.incNumAux();
                    continue;
                }
                if (reader.isCommit()) {
                    this.rollbackTracker.checkCommit(reader.getLastLsn(), reader.getTxnCommitId());
                    this.committedTxnIds.put(reader.getTxnCommitId(), reader.getLastLsn());
                    counter.incNumAux();
                    continue;
                }
                if (reader.isRollbackStart()) {
                    this.rollbackTracker.register((RollbackStart)reader.getMainItem(), reader.getLastLsn());
                    counter.incNumAux();
                    continue;
                }
                if (reader.isRollbackEnd()) {
                    this.rollbackTracker.register((RollbackEnd)reader.getMainItem(), reader.getLastLsn());
                    counter.incNumAux();
                    continue;
                }
                throw EnvironmentFailureException.unexpectedState(this.envImpl, "LNreader should not have picked up type " + reader.dumpCurrentHeader());
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
            this.rollbackTracker.singlePassSetInvisible();
        }
        catch (RuntimeException e) {
            this.traceAndThrowException(reader.getLastLsn(), "undoLNs", e);
        }
    }

    private boolean isReplicatedUncommittedLN(LNFileReader reader, Long txnId) {
        if (!this.envImpl.isReplicated()) {
            return false;
        }
        if (this.abortedTxnIds.contains(txnId)) {
            return false;
        }
        return reader.entryIsReplicated();
    }

    private void createReplayTxn(long txnId) throws DatabaseException {
        if (this.info.replayTxns.get(txnId) == null) {
            this.info.replayTxns.put(txnId, this.envImpl.createReplayTxn(txnId));
        }
    }

    private void handlePrepare(LNFileReader reader) throws DatabaseException {
        long prepareId = reader.getTxnPrepareId();
        Long prepareIdL = prepareId;
        if (!this.committedTxnIds.containsKey(prepareIdL) && !this.abortedTxnIds.contains(prepareIdL)) {
            TransactionConfig txnConf = new TransactionConfig();
            PreparedTxn preparedTxn = PreparedTxn.createPreparedTxn(this.envImpl, txnConf, prepareId);
            preparedTxn.setLockTimeout(0L);
            this.preparedTxns.put(prepareIdL, preparedTxn);
            preparedTxn.setPrepared(true);
            this.envImpl.getTxnManager().registerXATxn(reader.getTxnPrepareXid(), preparedTxn, true);
            LoggerUtils.logMsg(this.logger, this.envImpl, Level.INFO, "Found unfinished prepare record: id: " + reader.getTxnPrepareId() + " Xid: " + reader.getTxnPrepareXid());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoUncommittedLN(LNFileReader reader, DbTree dbMapTree) throws DatabaseException {
        this.envImpl.invokeEvictor();
        DatabaseId dbId = reader.getDatabaseId();
        DatabaseImpl db = dbMapTree.getDb(dbId);
        if (db == null) {
            return;
        }
        LNLogEntry<?> lnEntry = reader.getLNLogEntry();
        lnEntry.postFetchInit(db);
        LN ln = lnEntry.getLN();
        TreeLocation location = new TreeLocation();
        long logLsn = reader.getLastLsn();
        try {
            MapLN mapLN;
            ln.postFetchInit(db, logLsn);
            this.recoveryUndo(location, db, lnEntry, logLsn);
            this.undoUtilizationInfo(lnEntry, db, logLsn, reader.getLastEntrySize());
            this.inListBuildDbIds.add(dbId);
            if (ln instanceof MapLN && (mapLN = (MapLN)ln).getDatabase().isTemporary()) {
                this.tempDbIds.add(mapLN.getDatabase().getId());
            }
        }
        finally {
            dbMapTree.releaseDb(db);
        }
    }

    private void recoveryUndo(TreeLocation location, DatabaseImpl db, LNLogEntry lnEntry, long logLsn) {
        RecoveryManager.undo(this.logger, Level.FINE, location, db, lnEntry, logLsn, lnEntry.getAbortLsn(), lnEntry.getAbortKnownDeleted(), false, lnEntry.getAbortKey(), lnEntry.getAbortData(), lnEntry.getAbortVLSN(), lnEntry.getAbortExpiration(), lnEntry.isAbortExpirationInHours());
    }

    public static void abortUndo(Logger logger, Level traceLevel, TreeLocation location, DatabaseImpl db, LNLogEntry lnEntry, long logLsn) {
        RecoveryManager.undo(logger, traceLevel, location, db, lnEntry, logLsn, lnEntry.getAbortLsn(), lnEntry.getAbortKnownDeleted(), false, lnEntry.getAbortKey(), lnEntry.getAbortData(), lnEntry.getAbortVLSN(), lnEntry.getAbortExpiration(), lnEntry.isAbortExpirationInHours());
    }

    public static void rollbackUndo(Logger logger, Level traceLevel, TreeLocation location, DatabaseImpl db, LNLogEntry lnEntry, long undoLsn, TxnChain.RevertInfo revertTo) {
        RecoveryManager.undo(logger, traceLevel, location, db, lnEntry, undoLsn, revertTo.revertLsn, revertTo.revertKD, revertTo.revertPD, revertTo.revertKey, revertTo.revertData, revertTo.revertVLSN, revertTo.revertExpiration, revertTo.revertExpirationInHours);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void undo(Logger logger, Level traceLevel, TreeLocation location, DatabaseImpl db, LNLogEntry lnEntry, long logLsn, long revertLsn, boolean revertKD, boolean revertPD, byte[] revertKey, byte[] revertData, long revertVLSN, int revertExpiration, boolean revertExpirationInHours) throws DatabaseException {
        boolean found = false;
        boolean replaced = false;
        boolean success = false;
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, lnEntry.getKey(), false, false, CacheMode.DEFAULT);
            if (found) {
                boolean updateEntry;
                BIN bin = location.bin;
                int slotIdx = location.index;
                long slotLsn = location.childLsn;
                if (slotLsn == -1L) {
                    if (!bin.isEntryKnownDeleted(slotIdx) && !bin.isEntryPendingDeleted(slotIdx)) {
                        throw EnvironmentFailureException.unexpectedState(location + " has a NULL_LSN but the " + "slot is not empty. KD=" + bin.isEntryKnownDeleted(slotIdx) + " PD=" + bin.isEntryPendingDeleted(slotIdx));
                    }
                    bin.queueSlotDeletion(slotIdx);
                    success = true;
                    return;
                }
                boolean bl = updateEntry = DbLsn.compareTo(logLsn, slotLsn) == 0;
                if (updateEntry) {
                    int revertLogrecSize = 0;
                    if (revertLsn != -1L && !bin.isEmbeddedLN(slotIdx) && revertData == null) {
                        revertLogrecSize = RecoveryManager.fetchLNSize(db, 0, revertLsn);
                    }
                    bin.recoverRecord(slotIdx, revertLsn, revertKD, revertPD, revertKey, revertData, revertVLSN, revertLogrecSize, revertExpiration, revertExpirationInHours);
                    replaced = true;
                }
            }
            success = true;
        }
        finally {
            if (location.bin != null) {
                location.bin.releaseLatch();
            }
            RecoveryManager.trace(logger, traceLevel, db, TRACE_LN_UNDO, success, lnEntry.getLN(), logLsn, location.bin, found, replaced, false, location.childLsn, revertLsn, location.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redoLNs(Set<LogEntryType> lnTypes, StartupTracker.Counter counter) throws DatabaseException {
        long endOfFileLsn = this.info.nextAvailableLsn;
        long firstActiveLsn = this.info.firstActiveLsn;
        LNFileReader reader = new LNFileReader(this.envImpl, this.readBufferSize, firstActiveLsn, true, -1L, endOfFileLsn, null, this.info.checkpointEndLsn);
        for (LogEntryType lt : lnTypes) {
            reader.addTargetType(lt);
        }
        DbTree dbMapTree = this.envImpl.getDbTree();
        TreeLocation location = new TreeLocation();
        try {
            while (reader.readNextEntry()) {
                counter.incNumRead();
                RedoEligible eligible = this.eligibleForRedo(reader);
                if (!eligible.isEligible) continue;
                this.envImpl.invokeEvictor();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                long logrecLsn = reader.getLastLsn();
                if (db == null) {
                    counter.incNumDeleted();
                    this.tracker.countObsoleteIfUncounted(logrecLsn, logrecLsn, null, reader.getLastEntrySize(), dbId, false);
                    continue;
                }
                try {
                    LNLogEntry<?> logrec = reader.getLNLogEntry();
                    logrec.postFetchInit(db);
                    counter.incNumProcessed();
                    this.redoOneLN(reader, logrec, logrecLsn, dbId, db, eligible, location);
                }
                finally {
                    dbMapTree.releaseDb(db);
                }
            }
            counter.setRepeatIteratorReads(reader.getNRepeatIteratorReads());
        }
        catch (Exception e) {
            this.traceAndThrowException(reader.getLastLsn(), "redoLns", e);
        }
    }

    private RedoEligible eligibleForRedo(LNFileReader reader) {
        if (!reader.isLN()) {
            return RedoEligible.NOT;
        }
        if (reader.isInvisible()) {
            return RedoEligible.NOT;
        }
        boolean afterCheckpointStart = this.info.checkpointStartLsn == -1L ? true : DbLsn.compareTo(reader.getLastLsn(), this.info.checkpointStartLsn) >= 0;
        Long txnId = reader.getTxnId();
        Txn preparedTxn = this.preparedTxns.get(txnId);
        Txn replayTxn = this.info.replayTxns.get(txnId);
        if (preparedTxn != null) {
            return new RedoEligible(preparedTxn);
        }
        if (replayTxn != null) {
            return new RedoEligible(replayTxn);
        }
        if (afterCheckpointStart) {
            if (txnId == null) {
                return RedoEligible.ELIGIBLE_NON_TXNAL;
            }
            Long commitLongLsn = this.committedTxnIds.get(txnId);
            if (commitLongLsn != null) {
                return new RedoEligible(commitLongLsn);
            }
        }
        return RedoEligible.NOT;
    }

    private void redoOneLN(LNFileReader reader, LNLogEntry logrec, long logrecLsn, DatabaseId dbId, DatabaseImpl db, RedoEligible eligible, TreeLocation location) throws DatabaseException {
        boolean treeLsnIsImmediatelyObsolete;
        NameLNLogEntry nameLNEntry;
        int logrecSize = reader.getLastEntrySize();
        LN ln = logrec.getLN();
        ln.postFetchInit(db, logrecLsn);
        if (eligible.resurrectTxn != null) {
            this.relock(eligible.resurrectTxn, logrecLsn, logrec, db);
        }
        long treeLsn = this.redo(db, location, logrec, logrecLsn, logrecSize, eligible);
        this.inListBuildDbIds.add(dbId);
        MapLN mapLN = null;
        if (ln instanceof MapLN) {
            mapLN = (MapLN)ln;
            if (mapLN.getDatabase().isTemporary()) {
                this.tempDbIds.add(mapLN.getDatabase().getId());
            }
            if (mapLN.isDeleted()) {
                mapLN.getDatabase().countObsoleteDb(this.tracker, logrecLsn);
            }
        }
        if (eligible.resurrectTxn == null && (nameLNEntry = reader.getNameLNLogEntry()) != null) {
            switch (nameLNEntry.getOperationType()) {
                case REMOVE: {
                    assert (nameLNEntry.isDeleted());
                    NameLN nameLN = (NameLN)nameLNEntry.getLN();
                    this.expectDeletedMapLNs.add(nameLN.getId());
                    break;
                }
                case TRUNCATE: {
                    DatabaseId truncateId = nameLNEntry.getTruncateOldDbId();
                    assert (truncateId != null);
                    this.expectDeletedMapLNs.add(truncateId);
                }
            }
        }
        if (!(treeLsnIsImmediatelyObsolete = db.isLNImmediatelyObsolete()) && treeLsn != -1L) {
            treeLsnIsImmediatelyObsolete = location.isEmbedded || location.isKD;
        }
        this.redoUtilizationInfo(logrec, reader.getLastEntrySize(), logrecLsn, treeLsn, treeLsnIsImmediatelyObsolete, location.childLoggedSize, eligible.commitLsn, eligible.isCommitted(), db);
    }

    private void relock(Txn txn, long logLsn, LNLogEntry logrec, DatabaseImpl db) throws DatabaseException {
        txn.addLogInfo(logLsn);
        LockResult result = txn.nonBlockingLock(logLsn, LockType.WRITE, false, db);
        if (result.getLockGrant() == LockGrantType.DENIED) {
            throw EnvironmentFailureException.unexpectedState("Resurrected lock denied txn=" + txn.getId() + " logLsn=" + DbLsn.getNoFormatString(logLsn) + " abortLsn=" + DbLsn.getNoFormatString(logrec.getAbortLsn()));
        }
        result.setAbortInfo(logrec.getAbortLsn(), logrec.getAbortKnownDeleted(), logrec.getAbortKey(), logrec.getAbortData(), logrec.getAbortVLSN(), logrec.getAbortExpiration(), logrec.isAbortExpirationInHours(), db);
        WriteLockInfo wli = result.getWriteLockInfo();
        if (wli == null) {
            throw EnvironmentFailureException.unexpectedState("Resurrected lock has no write info txn=" + txn.getId() + " logLsn=" + DbLsn.getNoFormatString(logLsn) + " abortLsn=" + DbLsn.getNoFormatString(logrec.getAbortLsn()));
        }
        wli.setAbortLogSize(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long redo(DatabaseImpl db, TreeLocation location, LNLogEntry logrec, long logrecLsn, int logrecSize, RedoEligible eligible) throws DatabaseException {
        boolean found = false;
        boolean foundNotKD = false;
        boolean replaced = false;
        boolean inserted = false;
        boolean success = false;
        DbConfigManager configManager = db.getEnv().getConfigManager();
        LogEntryType logrecType = logrec.getLogType();
        LN logrecLN = logrec.getLN();
        long logrecVLSN = logrecLN.getVLSNSequence();
        boolean isDeletion = logrecLN.isDeleted();
        byte[] logrecKey = logrec.getKey();
        byte[] logrecData = logrec.getEmbeddedData();
        long abortLsn = logrec.getAbortLsn();
        boolean abortKD = logrec.getAbortKnownDeleted();
        int expiration = logrec.getExpiration();
        boolean expirationInHours = logrec.isExpirationInHours();
        long treeLsn = -1L;
        boolean blindInsertions = !(!configManager.getBoolean(EnvironmentParams.BIN_DELTA_BLIND_OPS) || !eligible.isCommitted() || !db.isLNImmediatelyObsolete() && (abortLsn != -1L && !abortKD || !logrecType.equals(LogEntryType.LOG_INS_LN_TRANSACTIONAL) && !logrecType.equals(LogEntryType.LOG_INS_LN)));
        try {
            location.reset();
            found = db.getTree().getParentBINForChildLN(location, logrecKey, true, blindInsertions, CacheMode.DEFAULT);
            if (!found && location.bin == null) {
                success = true;
                long l = -1L;
                return l;
            }
            BIN bin = location.bin;
            int index = location.index;
            boolean bl = foundNotKD = found && !bin.isEntryKnownDeleted(index);
            if (foundNotKD) {
                treeLsn = location.childLsn;
                int lsnCmp = DbLsn.compareTo(logrecLsn, treeLsn);
                if (lsnCmp >= 0) {
                    boolean redoKD = false;
                    boolean redoPD = false;
                    if (isDeletion) {
                        if (eligible.resurrectTxn != null) {
                            redoPD = true;
                        } else {
                            redoKD = true;
                        }
                    }
                    if (lsnCmp > 0) {
                        bin.recoverRecord(index, logrecLsn, redoKD, redoPD, logrecKey, logrecData, logrecVLSN, logrecSize, expiration, expirationInHours);
                        replaced = true;
                    } else if (isDeletion) {
                        if (redoKD) {
                            if (!bin.isEntryKnownDeleted(index)) {
                                bin.setKnownDeleted(index);
                            }
                        } else {
                            assert (bin.isEntryPendingDeleted(index));
                            assert (!bin.isEntryKnownDeleted(index));
                        }
                    }
                    if (isDeletion) {
                        bin.queueSlotDeletion(index);
                    }
                }
            } else if (found) {
                treeLsn = bin.getLsn(index);
                if (!isDeletion) {
                    if (treeLsn == -1L || DbLsn.compareTo(logrecLsn, treeLsn) > 0) {
                        bin.recoverRecord(index, logrecLsn, false, false, logrecKey, logrecData, logrecVLSN, logrecSize, expiration, expirationInHours);
                        inserted = true;
                    }
                } else {
                    bin.queueSlotDeletion(index);
                    assert (treeLsn == -1L || DbLsn.compareTo(logrecLsn, treeLsn) <= 0);
                }
            } else if (bin.isBINDelta()) {
                assert (blindInsertions);
                index = bin.insertEntry1(null, logrecKey, logrecData, logrecLsn, true);
                assert ((index & 0x20000) != 0);
                inserted = true;
                location.index = index &= 0xFFFDFFFF;
                bin.setLastLoggedSize(index, logrecSize);
                bin.setExpiration(index, expiration, expirationInHours);
                if (bin.isEmbeddedLN(index)) {
                    bin.setCachedVLSN(index, logrecVLSN);
                }
                if (isDeletion) {
                    assert (eligible.resurrectTxn == null);
                    bin.setKnownDeleted(index);
                }
            } else if (!isDeletion) {
                index = bin.insertEntry1(null, logrecKey, logrecData, logrecLsn, false);
                assert ((index & 0x20000) != 0);
                inserted = true;
                location.index = index &= 0xFFFDFFFF;
                bin.setLastLoggedSize(index, logrecSize);
                bin.setExpiration(index, expiration, expirationInHours);
                if (bin.isEmbeddedLN(index)) {
                    bin.setCachedVLSN(index, logrecVLSN);
                }
            }
            logrecLN.releaseMemoryBudget();
            success = true;
            long l = treeLsn;
            return l;
        }
        finally {
            if (location.bin != null) {
                location.bin.releaseLatch();
            }
            RecoveryManager.trace(this.logger, db, TRACE_LN_REDO, success, logrecLN, logrecLsn, location.bin, foundNotKD, replaced, inserted, location.childLsn, -1L, location.index);
        }
    }

    private void redoUtilizationInfo(LNLogEntry logrec, int logrecSize, long logrecLsn, long treeLsn, boolean treeLsnIsImmediatelyObsolete, int treeLNLoggedSize, long commitLsn, boolean isCommitted, DatabaseImpl db) {
        if (logrec.isImmediatelyObsolete(db)) {
            this.tracker.countObsoleteIfUncounted(logrecLsn, logrecLsn, null, logrecSize, db.getId(), false);
        }
        if (db.isLNImmediatelyObsolete()) {
            return;
        }
        if (treeLsn != -1L) {
            int cmpLogLsnToTreeLsn = DbLsn.compareTo(logrecLsn, treeLsn);
            if (cmpLogLsnToTreeLsn < 0) {
                if (!logrec.isImmediatelyObsolete(db)) {
                    this.tracker.countObsoleteIfUncounted(logrecLsn, treeLsn, null, RecoveryManager.fetchLNSize(db, logrecSize, logrecLsn), db.getId(), !this.resurrectedLsns.contains(treeLsn));
                }
            } else if (cmpLogLsnToTreeLsn > 0 && !treeLsnIsImmediatelyObsolete) {
                this.tracker.countObsoleteIfUncounted(treeLsn, logrecLsn, null, RecoveryManager.fetchLNSize(db, treeLNLoggedSize, treeLsn), db.getId(), isCommitted);
            }
        }
        long abortLsn = logrec.getAbortLsn();
        boolean abortKD = logrec.getAbortKnownDeleted();
        if (commitLsn != -1L && abortLsn != -1L && !abortKD && logrec.getAbortData() == null && (treeLsn == -1L || DbLsn.compareTo(logrecLsn, treeLsn) <= 0 && DbLsn.compareTo(abortLsn, this.info.checkpointStartLsn) < 0)) {
            this.tracker.countObsoleteIfUncounted(abortLsn, commitLsn, null, 0, db.getId(), true);
        }
    }

    private void undoUtilizationInfo(LNLogEntry logrec, DatabaseImpl db, long logrecLsn, int logrecSize) {
        if (logrec.isImmediatelyObsolete(db)) {
            this.tracker.countObsoleteIfUncounted(logrecLsn, logrecLsn, null, logrecSize, db.getId(), false);
        } else {
            this.tracker.countObsoleteUnconditional(logrecLsn, null, logrecSize, db.getId(), true);
        }
    }

    private static int fetchLNSize(DatabaseImpl db, int size, long lsn) throws DatabaseException {
        if (size != 0) {
            return size;
        }
        EnvironmentImpl envImpl = db.getEnv();
        if (!envImpl.getCleaner().getFetchObsoleteSize(db)) {
            return 0;
        }
        try {
            LogEntryHeader header = envImpl.getLogManager().getWholeLogEntry(lsn).getHeader();
            return header.getEntrySize();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildINList() throws DatabaseException {
        this.envImpl.getInMemoryINs().enable();
        this.envImpl.getEvictor().setEnabled(true);
        this.envImpl.getDbTree().rebuildINListMapDb();
        for (DatabaseId dbId : this.inListBuildDbIds) {
            if (dbId.equals(DbTree.ID_DB_ID)) continue;
            DatabaseImpl db = this.envImpl.getDbTree().getDb(dbId);
            try {
                if (db == null || db.isTemporary()) continue;
                db.getTree().rebuildINList();
            }
            finally {
                this.envImpl.getDbTree().releaseDb(db);
            }
        }
    }

    private void removeTempDbs() throws DatabaseException {
        this.startupTracker.start(StartupTracker.Phase.REMOVE_TEMP_DBS);
        this.startupTracker.setProgress(RecoveryProgress.REMOVE_TEMP_DBS);
        StartupTracker.Counter counter = this.startupTracker.getCounter(StartupTracker.Phase.REMOVE_TEMP_DBS);
        DbTree dbMapTree = this.envImpl.getDbTree();
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, false);
        boolean operationOk = false;
        try {
            Iterator<DatabaseId> removeDbs = this.tempDbIds.iterator();
            while (removeDbs.hasNext()) {
                counter.incNumRead();
                DatabaseId dbId = removeDbs.next();
                DatabaseImpl db = dbMapTree.getDb(dbId);
                dbMapTree.releaseDb(db);
                if (db == null) continue;
                assert (db.isTemporary());
                if (!db.isDeleted()) {
                    try {
                        counter.incNumProcessed();
                        this.envImpl.getDbTree().dbRemove(locker, db.getName(), db.getId());
                        continue;
                    }
                    catch (DbTree.NeedRepLockerException e) {
                        throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
                    }
                    catch (DatabaseNotFoundException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                }
                counter.incNumDeleted();
            }
            operationOk = true;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
        finally {
            locker.operationEnd(operationOk);
            this.startupTracker.stop(StartupTracker.Phase.REMOVE_TEMP_DBS);
        }
    }

    private void deleteMapLNs() {
        for (DatabaseId id : this.expectDeletedMapLNs) {
            DatabaseImpl dbImpl = this.envImpl.getDbTree().getDb(id);
            if (dbImpl == null) continue;
            dbImpl.finishDeleteProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLogVersion8UpgradeViolations() throws EnvironmentFailureException {
        boolean v8DupNodes = false;
        for (DatabaseId dbId : this.logVersion8UpgradeDbs) {
            DbTree dbTree = this.envImpl.getDbTree();
            DatabaseImpl db = dbTree.getDb(dbId);
            try {
                if (db == null || !db.getSortedDuplicates()) continue;
                v8DupNodes = true;
                break;
            }
            finally {
                dbTree.releaseDb(db);
            }
        }
        boolean v8Deltas = this.logVersion8UpgradeDeltas.get();
        if (v8DupNodes || v8Deltas) {
            String illegalEntries = v8DupNodes ? "JE 4.1 duplicate DB entries" : "JE 4.1 BINDeltas";
            throw EnvironmentFailureException.unexpectedState(illegalEntries + " were found in the recovery interval. " + "Before upgrading to JE 5.0, the following utility " + "must be run using JE 4.1 (4.1.20 or later): " + (this.envImpl.isReplicated() ? "DbRepPreUpgrade_4_1 " : "DbPreUpgrade_4_1 ") + ". See the change log.");
        }
    }

    private String printTrackList(List<TrackingInfo> trackingList) {
        if (trackingList != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<TrackingInfo> iter = trackingList.iterator();
            sb.append("Trace list:");
            sb.append('\n');
            while (iter.hasNext()) {
                sb.append(iter.next());
                sb.append('\n');
            }
            return sb.toString();
        }
        return null;
    }

    private static void trace(Logger logger, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        RecoveryManager.trace(logger, Level.FINE, database, debugType, success, node, logLsn, parent, found, replaced, inserted, replacedLsn, abortLsn, index);
    }

    private static void trace(Logger logger, Level level, DatabaseImpl database, String debugType, boolean success, Node node, long logLsn, IN parent, boolean found, boolean replaced, boolean inserted, long replacedLsn, long abortLsn, int index) {
        Level useLevel = level;
        if (!success) {
            useLevel = Level.SEVERE;
        }
        if (logger.isLoggable(useLevel)) {
            StringBuilder sb = new StringBuilder();
            sb.append(debugType);
            sb.append(" success=").append(success);
            if (node instanceof IN) {
                sb.append(" node=");
                sb.append(((IN)node).getNodeId());
            }
            sb.append(" lsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            if (parent != null) {
                sb.append(" parent=").append(parent.getNodeId());
            }
            sb.append(" found=");
            sb.append(found);
            sb.append(" replaced=");
            sb.append(replaced);
            sb.append(" inserted=");
            sb.append(inserted);
            if (replacedLsn != -1L) {
                sb.append(" replacedLsn=");
                sb.append(DbLsn.getNoFormatString(replacedLsn));
            }
            if (abortLsn != -1L) {
                sb.append(" abortLsn=");
                sb.append(DbLsn.getNoFormatString(abortLsn));
            }
            sb.append(" index=").append(index);
            if (useLevel.equals(Level.SEVERE)) {
                LoggerUtils.traceAndLog(logger, database.getEnv(), useLevel, sb.toString());
            } else {
                LoggerUtils.logMsg(logger, database.getEnv(), useLevel, sb.toString());
            }
        }
    }

    private void traceAndThrowException(long badLsn, String method, Exception originalException) throws DatabaseException {
        String badLsnString = DbLsn.getNoFormatString(badLsn);
        LoggerUtils.traceAndLogException(this.envImpl, "RecoveryManager", method, "last LSN = " + badLsnString, originalException);
        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "last LSN=" + badLsnString, originalException);
    }

    private static class RedoEligible {
        final boolean isEligible;
        final Txn resurrectTxn;
        final long commitLsn;
        static RedoEligible NOT = new RedoEligible(false);
        static RedoEligible ELIGIBLE_NON_TXNAL = new RedoEligible(true);

        RedoEligible(Txn resurrectTxn) {
            this.isEligible = true;
            this.resurrectTxn = resurrectTxn;
            this.commitLsn = -1L;
        }

        RedoEligible(long commitLsn) {
            this.isEligible = true;
            this.resurrectTxn = null;
            this.commitLsn = commitLsn;
        }

        RedoEligible(boolean eligible) {
            this.isEligible = eligible;
            this.resurrectTxn = null;
            this.commitLsn = -1L;
        }

        boolean isNonTransactional() {
            return this.isEligible && this.commitLsn == -1L && this.resurrectTxn == null;
        }

        boolean isCommitted() {
            return this.commitLsn != -1L || this.isNonTransactional();
        }
    }

    private static class RootUpdater
    implements WithRootLatched {
        private final Tree tree;
        private final IN inFromLog;
        private long lsn = -1L;
        private boolean inserted = false;
        private boolean replaced = false;
        private long originalLsn = -1L;
        private boolean inFromLogIsLatched = true;

        RootUpdater(Tree tree, IN inFromLog, long lsn) {
            this.tree = tree;
            this.inFromLog = inFromLog;
            this.lsn = lsn;
        }

        boolean getInFromLogIsLatched() {
            return this.inFromLogIsLatched;
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            ChildReference newRoot = this.tree.makeRootChildReference(this.inFromLog, new byte[0], this.lsn);
            this.inFromLog.releaseLatch();
            this.inFromLogIsLatched = false;
            if (root == null) {
                this.tree.setRoot(newRoot, false);
                this.inserted = true;
            } else {
                this.originalLsn = root.getLsn();
                if (DbLsn.compareTo(this.originalLsn, this.lsn) < 0) {
                    this.tree.setRoot(newRoot, false);
                    this.replaced = true;
                }
            }
            return null;
        }

        boolean updateDone() {
            return this.inserted || this.replaced;
        }

        boolean getInserted() {
            return this.inserted;
        }

        boolean getReplaced() {
            return this.replaced;
        }

        long getOriginalLsn() {
            return this.originalLsn;
        }
    }
}

