/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter.impl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.rep.arbiter.impl.ArbiterImpl;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.Protocol;
import com.sleepycat.je.utilint.LoggerUtils;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MonitorEventManager {
    private long joinTime = 0L;
    ArbiterImpl arbImpl;

    public MonitorEventManager(ArbiterImpl arbImpl) {
        this.arbImpl = arbImpl;
    }

    public long getJoinTime() {
        return this.joinTime;
    }

    public void disableLeaveGroupEvent() {
        this.joinTime = 0L;
    }

    public void notifyJoinGroup() throws DatabaseException {
        if (this.joinTime > 0L) {
            return;
        }
        RepGroupImpl repGroup = this.arbImpl.getGroup();
        if (repGroup == null) {
            return;
        }
        this.joinTime = System.currentTimeMillis();
        Protocol protocol = this.getProtocol(repGroup);
        protocol.getClass();
        Protocol.JoinGroup joinEvent = new Protocol.JoinGroup(protocol, this.arbImpl.getNodeName(), this.arbImpl.getMasterName(), this.joinTime);
        this.refreshMonitors(repGroup, joinEvent);
    }

    public void notifyLeaveGroup(LeaveGroupEvent.LeaveReason reason) throws DatabaseException, InterruptedException {
        if (this.joinTime == 0L) {
            return;
        }
        RepGroupImpl repGroup = this.arbImpl.getGroup();
        if (repGroup == null) {
            return;
        }
        Protocol protocol = this.getProtocol(repGroup);
        protocol.getClass();
        Protocol.LeaveGroup leaveEvent = new Protocol.LeaveGroup(protocol, this.arbImpl.getNodeName(), this.arbImpl.getMasterName(), reason, this.joinTime, System.currentTimeMillis());
        List<Future<TextProtocol.MessageExchange>> futures = this.refreshMonitors(repGroup, leaveEvent);
        for (Future<TextProtocol.MessageExchange> f : futures) {
            try {
                f.get(10L, TimeUnit.SECONDS);
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {}
        }
    }

    private Protocol getProtocol(RepGroupImpl repGroup) {
        return new Protocol(repGroup.getName(), NameIdPair.NOCHECK, null, this.arbImpl.getRepImpl().getChannelFactory());
    }

    private List<Future<TextProtocol.MessageExchange>> refreshMonitors(RepGroupImpl repGroup, TextProtocol.RequestMessage requestMessage) {
        Set<InetSocketAddress> monitors = repGroup.getAllMonitorSockets();
        LoggerUtils.info(this.arbImpl.getLogger(), this.arbImpl.getRepImpl(), "Refreshed " + monitors.size() + " monitors.");
        return Utils.broadcastMessage(monitors, "Monitor", requestMessage, this.arbImpl.getElections().getThreadPool());
    }
}

