/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.impl.BinaryNodeStateProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.JVMSystemUtils;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.util.logging.Logger;

public class BinaryNodeStateService
extends ServiceDispatcher.ExecutingService {
    private final RepNode repNode;
    private final ServiceDispatcher dispatcher;
    private final Logger logger;
    public static final String SERVICE_NAME = "BinaryNodeState";

    public BinaryNodeStateService(ServiceDispatcher dispatcher, RepNode repNode) {
        super(SERVICE_NAME, dispatcher);
        this.repNode = repNode;
        this.dispatcher = dispatcher;
        this.logger = LoggerUtils.getLogger(this.getClass());
        dispatcher.register(this);
    }

    public void shutdown() {
        this.dispatcher.cancel(SERVICE_NAME);
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        return new NodeStateServiceRunnable(dataChannel);
    }

    class NodeStateServiceRunnable
    implements Runnable {
        private DataChannel channel;

        NodeStateServiceRunnable(DataChannel channel) {
            this.channel = channel;
        }

        private BinaryNodeStateProtocol.BinaryNodeStateResponse createResponse(BinaryNodeStateProtocol protocol) {
            long joinTime = BinaryNodeStateService.this.repNode.getMonitorEventManager().getJoinTime();
            long txnEndVLSN = BinaryNodeStateService.this.repNode.getCurrentTxnEndVLSN() == null ? 0L : BinaryNodeStateService.this.repNode.getCurrentTxnEndVLSN().getSequence();
            long masterTxnEndVLSN = BinaryNodeStateService.this.repNode.replica().getMasterTxnEndVLSN();
            int activeFeeders = BinaryNodeStateService.this.repNode.feederManager().activeReplicaCount();
            BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
            binaryNodeStateProtocol.getClass();
            return binaryNodeStateProtocol.new BinaryNodeStateProtocol.BinaryNodeStateResponse(BinaryNodeStateService.this.repNode.getNodeName(), BinaryNodeStateService.this.repNode.getGroup().getName(), BinaryNodeStateService.this.repNode.getMasterName(), JEVersion.CURRENT_VERSION, joinTime, BinaryNodeStateService.this.repNode.getRepImpl().getState(), txnEndVLSN, masterTxnEndVLSN, activeFeeders, 12, BinaryNodeStateService.this.repNode.getAppState(), JVMSystemUtils.getSystemLoad());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BinaryNodeStateProtocol protocol = null;
            try {
                protocol = new BinaryNodeStateProtocol(NameIdPair.NOCHECK, BinaryNodeStateService.this.repNode.getRepImpl());
                try {
                    this.channel.getSocketChannel().configureBlocking(true);
                    BinaryNodeStateProtocol.BinaryNodeStateRequest msg = protocol.read(this.channel, BinaryNodeStateProtocol.BinaryNodeStateRequest.class);
                    String groupName = msg.getGroupName();
                    if (!BinaryNodeStateService.this.repNode.getGroup().getName().equals(groupName) || !BinaryNodeStateService.this.repNode.getNodeName().equals(msg.getNodeName())) {
                        throw new BinaryProtocol.ProtocolException("Sending the request to a wrong group or a wrong node.");
                    }
                    BinaryNodeStateProtocol.BinaryNodeStateResponse response = this.createResponse(protocol);
                    protocol.write((BinaryProtocol.Message)response, this.channel);
                    LoggerUtils.finest(BinaryNodeStateService.this.logger, BinaryNodeStateService.this.repNode.getRepImpl(), "Deal with a node state request successfully.");
                }
                catch (BinaryProtocol.ProtocolException e) {
                    LoggerUtils.info(BinaryNodeStateService.this.logger, BinaryNodeStateService.this.repNode.getRepImpl(), "Get a ProtocolException with message: " + LoggerUtils.exceptionTypeAndMsg(e) + " while dealing with a node state request.");
                    BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
                    binaryNodeStateProtocol.getClass();
                    protocol.write((BinaryProtocol.Message)new BinaryProtocol.ProtocolError((BinaryProtocol)binaryNodeStateProtocol, e.getMessage()), this.channel);
                }
                catch (Exception e) {
                    LoggerUtils.info(BinaryNodeStateService.this.logger, BinaryNodeStateService.this.repNode.getRepImpl(), "Unexpected exception: " + LoggerUtils.exceptionTypeAndMsg(e));
                    BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
                    binaryNodeStateProtocol.getClass();
                    protocol.write((BinaryProtocol.Message)new BinaryProtocol.ProtocolError((BinaryProtocol)binaryNodeStateProtocol, e.getMessage()), this.channel);
                }
                finally {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

