/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ScavengerFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.TxnChain;
import com.sleepycat.je.util.DbDump;
import com.sleepycat.je.utilint.BitMap;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.utilint.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DbScavenger
extends DbDump {
    private static final int FLUSH_INTERVAL = 100;
    private int readBufferSize;
    private EnvironmentImpl envImpl;
    private BitMap positiveCommittedTxnIdsSeen;
    private BitMap negativeCommittedTxnIdsSeen;
    private Set<TxnChain.CompareSlot> lnNodesSeen;
    private Map<Long, String> dbIdToName;
    private Map<Long, DatabaseImpl> dbIdToImpl;
    private Map<Long, PrintStream> dbIdToOutputStream;
    private boolean dumpCorruptedBounds = false;
    private int flushCounter = 0;
    private long lastTime;

    public DbScavenger(Environment env, String outputDirectory, boolean formatUsingPrintable, boolean doAggressiveScavengerRun, boolean verbose) {
        super(env, null, null, formatUsingPrintable);
        this.doAggressiveScavengerRun = doAggressiveScavengerRun;
        this.dbIdToName = new HashMap<Long, String>();
        this.dbIdToImpl = new HashMap<Long, DatabaseImpl>();
        this.dbIdToOutputStream = new HashMap<Long, PrintStream>();
        this.verbose = verbose;
        this.outputDirectory = outputDirectory;
    }

    public void setDumpCorruptedBounds(boolean dumpCorruptedBounds) {
        this.dumpCorruptedBounds = dumpCorruptedBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump() throws EnvironmentNotFoundException, EnvironmentLockedException, IOException {
        this.openEnv(false);
        this.envImpl = DbInternal.getEnvironmentImpl(this.env);
        DbConfigManager cm = this.envImpl.getConfigManager();
        this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        LastFileReader reader = new LastFileReader(this.envImpl, this.readBufferSize);
        while (reader.readNextEntry()) {
        }
        long lastUsedLsn = reader.getLastValidLsn();
        long nextAvailableLsn = reader.getEndOfLog();
        this.envImpl.getFileManager().setLastPosition(nextAvailableLsn, lastUsedLsn, reader.getPrevOffset());
        try {
            if (this.verbose) {
                System.out.println("Pass 1: " + new Date());
            }
            this.scavengeDbTree(lastUsedLsn, nextAvailableLsn);
            if (this.verbose) {
                System.out.println("Pass 2: " + new Date());
            }
            this.scavenge(lastUsedLsn, nextAvailableLsn);
            if (this.verbose) {
                System.out.println("End: " + new Date());
            }
        }
        finally {
            this.closeOutputStreams();
        }
    }

    private void scavengeDbTree(long lastUsedLsn, long nextAvailableLsn) throws DatabaseException {
        this.positiveCommittedTxnIdsSeen = new BitMap();
        this.negativeCommittedTxnIdsSeen = new BitMap();
        this.lnNodesSeen = new TreeSet<TxnChain.CompareSlot>();
        ScavengerFileReader scavengerReader = new ScavengerFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, -1L, nextAvailableLsn){

            @Override
            protected void processEntryCallback(LogEntry entry, LogEntryType entryType) throws DatabaseException {
                DbScavenger.this.processDbTreeEntry(entry, entryType);
            }
        };
        scavengerReader.setTargetType(LogEntryType.LOG_MAPLN);
        scavengerReader.setTargetType(LogEntryType.LOG_NAMELN_TRANSACTIONAL);
        scavengerReader.setTargetType(LogEntryType.LOG_NAMELN);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_COMMIT);
        scavengerReader.setTargetType(LogEntryType.LOG_TXN_ABORT);
        this.lastTime = System.currentTimeMillis();
        long fileNum = -1L;
        while (scavengerReader.readNextEntry()) {
            fileNum = this.reportProgress(fileNum, scavengerReader.getLastLsn());
        }
    }

    private long reportProgress(long fileNum, long lastLsn) {
        long currentFile = DbLsn.getFileNumber(lastLsn);
        if (this.verbose && currentFile != fileNum) {
            long now = System.currentTimeMillis();
            System.out.println("processing file " + FileManager.getFileName(currentFile, ".jdb  ") + (now - this.lastTime) + " ms");
            this.lastTime = now;
        }
        return currentFile;
    }

    private boolean checkProcessEntry(LogEntry entry, LogEntryType entryType, boolean pass2) {
        boolean isTransactional = entryType.isTransactional();
        if (isTransactional) {
            long txnId = entry.getTransactionId();
            if (entryType.equals(LogEntryType.LOG_TXN_COMMIT)) {
                this.setCommittedTxn(txnId);
                return false;
            }
            if (entryType.equals(LogEntryType.LOG_TXN_ABORT)) {
                return false;
            }
            if (!this.isCommittedTxn(txnId)) {
                return false;
            }
        }
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            long dbId = lnEntry.getDbId().getId();
            DatabaseImpl db = this.dbIdToImpl.get(dbId);
            if (db != null) {
                lnEntry.postFetchInit(db);
            } else {
                lnEntry.postFetchInit(false);
            }
            if (this.doAggressiveScavengerRun || !pass2) {
                return true;
            }
            if (db == null) {
                throw EnvironmentFailureException.unexpectedState("Database info not available for DB ID: " + dbId);
            }
            return this.lnNodesSeen.add(new TxnChain.CompareSlot(db, lnEntry));
        }
        return false;
    }

    private void processDbTreeEntry(LogEntry entry, LogEntryType entryType) throws DatabaseException {
        boolean processThisEntry = this.checkProcessEntry(entry, entryType, false);
        if (processThisEntry && entry instanceof LNLogEntry) {
            DatabaseImpl db;
            Long dbId;
            LNLogEntry lnEntry = (LNLogEntry)entry;
            LN ln = lnEntry.getLN();
            if (ln instanceof NameLN) {
                String name = StringUtils.fromUTF8(lnEntry.getKey());
                dbId = ((NameLN)ln).getId().getId();
                if (this.dbIdToName.containsKey(dbId) && !this.dbIdToName.get(dbId).equals(name)) {
                    throw EnvironmentFailureException.unexpectedState("Already name mapped for dbId: " + dbId + " changed from " + this.dbIdToName.get(dbId) + " to " + name);
                }
                this.dbIdToName.put(dbId, name);
            }
            if (ln instanceof MapLN && !this.dbIdToImpl.containsKey(dbId = Long.valueOf((db = ((MapLN)ln).getDatabase()).getId().getId()))) {
                this.dbIdToImpl.put(dbId, db);
            }
        }
    }

    private void scavenge(long lastUsedLsn, long nextAvailableLsn) throws DatabaseException {
        ScavengerFileReader scavengerReader = new ScavengerFileReader(this.envImpl, this.readBufferSize, lastUsedLsn, -1L, nextAvailableLsn){

            @Override
            protected void processEntryCallback(LogEntry entry, LogEntryType entryType) throws DatabaseException {
                DbScavenger.this.processRegularEntry(entry, entryType);
            }
        };
        for (LogEntryType entryType : LogEntryType.getAllTypes()) {
            if (!entryType.isUserLNType()) continue;
            scavengerReader.setTargetType(entryType);
        }
        scavengerReader.setDumpCorruptedBounds(this.dumpCorruptedBounds);
        long progressFileNum = -1L;
        while (scavengerReader.readNextEntry()) {
            progressFileNum = this.reportProgress(progressFileNum, scavengerReader.getLastLsn());
        }
    }

    private void processRegularEntry(LogEntry entry, LogEntryType entryType) throws DatabaseException {
        boolean processThisEntry = this.checkProcessEntry(entry, entryType, true);
        if (processThisEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            Long dbId = lnEntry.getDbId().getId();
            LN ln = lnEntry.getLN();
            PrintStream out = this.getOutputStream(dbId);
            if (!ln.isDeleted()) {
                DatabaseEntry key = new DatabaseEntry();
                DatabaseEntry data = new DatabaseEntry();
                lnEntry.getUserKeyData(key, data);
                this.dumpOne(out, key.getData(), this.formatUsingPrintable);
                this.dumpOne(out, data.getData(), this.formatUsingPrintable);
                if (++this.flushCounter % 100 == 0) {
                    out.flush();
                    this.flushCounter = 0;
                }
            }
        }
    }

    private PrintStream getOutputStream(Long dbId) throws DatabaseException {
        PrintStream ret = this.dbIdToOutputStream.get(dbId);
        if (ret != null) {
            return ret;
        }
        String name = this.dbIdToName.get(dbId);
        if (name == null) {
            name = "db" + dbId;
        }
        File file = new File(this.outputDirectory, name + ".dump");
        try {
            ret = new PrintStream(new FileOutputStream(file), false);
        }
        catch (FileNotFoundException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        this.dbIdToOutputStream.put(dbId, ret);
        DatabaseImpl db = this.dbIdToImpl.get(dbId);
        boolean dupSort = db != null ? db.getSortedDuplicates() : false;
        this.printHeader(ret, dupSort, this.formatUsingPrintable);
        return ret;
    }

    private void closeOutputStreams() {
        for (PrintStream s : this.dbIdToOutputStream.values()) {
            s.println("DATA=END");
            s.close();
        }
    }

    private void setCommittedTxn(long txnId) {
        if (txnId >= 0L) {
            this.positiveCommittedTxnIdsSeen.set(txnId);
        } else {
            this.negativeCommittedTxnIdsSeen.set(0L - txnId);
        }
    }

    private boolean isCommittedTxn(long txnId) {
        if (txnId >= 0L) {
            return this.positiveCommittedTxnIdsSeen.get(txnId);
        }
        return this.negativeCommittedTxnIdsSeen.get(0L - txnId);
    }
}

