/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.Stack;
import java.util.Vector;
import org.reldb.rel.client.Error;
import org.reldb.rel.client.Heading;
import org.reldb.rel.client.Response;
import org.reldb.rel.client.Scalar;
import org.reldb.rel.client.ScalarType;
import org.reldb.rel.client.Selector;
import org.reldb.rel.client.Tuple;
import org.reldb.rel.client.Tuples;
import org.reldb.rel.client.Value;
import org.reldb.rel.client.connection.CrashHandler;
import org.reldb.rel.client.connection.stream.ClientFromURL;
import org.reldb.rel.client.connection.stream.ClientLocalConnection;
import org.reldb.rel.client.connection.stream.InputStreamInterceptor;
import org.reldb.rel.client.connection.stream.StreamReceiverClient;
import org.reldb.rel.client.parser.ResponseAdapter;
import org.reldb.rel.client.parser.ResponseToHTMLProgressive;
import org.reldb.rel.client.parser.core.ParseException;
import org.reldb.rel.client.parser.core.ResponseParser;
import org.reldb.rel.exceptions.DatabaseFormatVersionException;

public class Connection {
    private String dbURL;
    private String serverAnnouncement = "";
    private CrashHandler crashHandler;
    private String[] additionalJars;
    private static final String errorPrefix = "ERROR:";
    private Vector<CharacterListener> characterListeners = new Vector();

    public Connection(String dbURL, boolean createDbAllowed, CrashHandler crashHandler, String[] additionalJars) throws NumberFormatException, MalformedURLException, IOException, DatabaseFormatVersionException {
        this.dbURL = dbURL;
        this.crashHandler = crashHandler;
        this.additionalJars = additionalJars;
        ClientFromURL.openConnection(dbURL, createDbAllowed, crashHandler, additionalJars).close();
    }

    public static void convertToLatestFormat(String dbURL, PrintStream conversionOutput, String[] additionalJars) throws DatabaseFormatVersionException, IOException {
        ClientLocalConnection.convertToLatestFormat(dbURL, conversionOutput, additionalJars);
    }

    public String getDbURL() {
        return this.dbURL;
    }

    public CrashHandler getCrashHandler() {
        return this.crashHandler;
    }

    public String[] getAdditionalJars() {
        return this.additionalJars;
    }

    public void addCharacterListener(CharacterListener listener) {
        this.characterListeners.addElement(listener);
    }

    public void removeCharacterListener(CharacterListener listener) {
        this.characterListeners.removeElement(listener);
    }

    protected void capturedResponseStream(int character) {
        for (CharacterListener listener : this.characterListeners) {
            listener.receive(character);
        }
    }

    private void launchTransmitter(final StreamReceiverClient client, final Action action) {
        Thread sendRunner = new Thread(){

            @Override
            public void run() {
                try {
                    action.run(client);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        sendRunner.start();
    }

    private Response launchParser(Action sendAction, final Action receiveComplete) {
        StreamReceiverClient client;
        final Response response = new Response();
        try {
            client = ClientFromURL.openConnection(this.dbURL, false, this.crashHandler, this.additionalJars);
        }
        catch (Exception e) {
            response.setResult(new Error(e.toString()));
            return response;
        }
        Thread parseRunner = new Thread(){

            @Override
            public void run() {
                ResponseParser parser;
                ErrorMessageTrap errorMessageTrap;
                try {
                    errorMessageTrap = new ErrorMessageTrap(client.getServerResponseInputStream());
                    parser = new ResponseParser(errorMessageTrap);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                parser.setResponseHandler(new ResponseAdapter(){
                    Stack<Value> valueReceiver = new Stack();
                    Stack<Heading> headingReceiver = new Stack();

                    private void endData() {
                        Value value = this.valueReceiver.pop();
                        if (this.valueReceiver.size() > 0) {
                            this.valueReceiver.peek().addValue(value, false);
                        } else {
                            response.setResult(value);
                        }
                    }

                    @Override
                    public void beginHeading(String typeName) {
                        Heading heading = new Heading(typeName);
                        this.headingReceiver.push(heading);
                    }

                    @Override
                    public Heading endHeading() {
                        Heading heading = this.headingReceiver.pop();
                        if (this.headingReceiver.size() > 0) {
                            this.headingReceiver.peek().addAttributeType(heading);
                        }
                        return heading;
                    }

                    @Override
                    public void attributeName(String name) {
                        this.headingReceiver.peek().addAttributeName(name);
                    }

                    @Override
                    public void typeReference(String name) {
                        this.headingReceiver.peek().addAttributeType(new ScalarType(name));
                    }

                    @Override
                    public void beginScalar(int depth) {
                        this.valueReceiver.push(new Scalar());
                    }

                    @Override
                    public void endScalar(int depth) {
                        this.endData();
                    }

                    @Override
                    public void beginPossrep(String name) {
                        this.valueReceiver.push(new Selector(name));
                    }

                    @Override
                    public void endPossrep() {
                        this.endData();
                    }

                    @Override
                    public void primitive(String value, boolean quoted) {
                        this.valueReceiver.peek().addValue(new Scalar(value, quoted), quoted);
                    }

                    @Override
                    public void beginContainerBody(int depth, Heading heading, String typeName) {
                        Tuples tuples;
                        Tuples tuples2 = tuples = heading == null ? new Tuples(typeName) : new Tuples(heading);
                        if (depth == 0) {
                            response.setResult(tuples);
                        }
                        this.valueReceiver.push(tuples);
                    }

                    @Override
                    public void endContainer(int depth) {
                        Tuples tuples = (Tuples)this.valueReceiver.peek();
                        tuples.insertNullTuple();
                        this.endData();
                    }

                    @Override
                    public void beginTuple(int depth) {
                        this.valueReceiver.push(new Tuple());
                    }

                    @Override
                    public void endTuple(int depth) {
                        this.endData();
                    }

                    @Override
                    public void attributeNameInTuple(int depth, String name) {
                        ((Tuple)this.valueReceiver.peek()).addAttributeName(name);
                    }
                });
                try {
                    parser.parse();
                }
                catch (ParseException e) {
                    response.setResult(new Error(errorMessageTrap.toString()));
                }
                try {
                    if (receiveComplete != null) {
                        receiveComplete.run(client);
                    }
                    client.close();
                }
                catch (IOException e) {
                    System.out.println("Connection: run failed: " + e);
                    e.printStackTrace();
                }
            }
        };
        parseRunner.start();
        this.launchTransmitter(client, sendAction);
        return response;
    }

    private void launchParserToHTML(Action action, final HTMLReceiver htmlReceiver) {
        StreamReceiverClient client;
        try {
            client = ClientFromURL.openConnection(this.dbURL, false, this.crashHandler, this.additionalJars);
        }
        catch (Exception e) {
            htmlReceiver.emitInitialHTML("Unable to open connection: " + e.toString().replace(" ", "&nbsp;"));
            return;
        }
        Thread parseRunner = new Thread(){

            @Override
            public void run() {
                ResponseToHTMLProgressive parser;
                ErrorMessageTrap errorMessageTrap;
                try {
                    errorMessageTrap = new ErrorMessageTrap(client.getServerResponseInputStream());
                    parser = new ResponseToHTMLProgressive(errorMessageTrap){

                        @Override
                        public void emitInitialHTML(String s) {
                            htmlReceiver.emitInitialHTML(s);
                        }

                        @Override
                        public void endInitialHTML() {
                            htmlReceiver.endInitialHTML();
                        }

                        @Override
                        public void emitProgressiveHTML(String s) {
                            htmlReceiver.emitProgressiveHTML(s);
                        }

                        @Override
                        public void endProgressiveHTMLRow() {
                            htmlReceiver.endProgressiveHTMLRow();
                        }
                    };
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return;
                }
                try {
                    parser.parse();
                }
                catch (ParseException e) {
                    htmlReceiver.emitInitialHTML(errorMessageTrap.toString().replace(" ", "&nbsp;"));
                }
                try {
                    client.close();
                }
                catch (IOException e) {
                    System.out.println("Connection: close failed: " + e);
                    e.printStackTrace();
                }
            }
        };
        parseRunner.start();
        this.launchTransmitter(client, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(final String input) throws IOException {
        final Indicator finished = new Indicator();
        Response response = this.launchParser(new Action(this){

            @Override
            public void run(StreamReceiverClient client) throws IOException {
                client.sendExecute(input);
            }
        }, new Action(this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(StreamReceiverClient client) throws IOException {
                Indicator indicator = finished;
                synchronized (indicator) {
                    finished.setIndicated(true);
                    finished.notify();
                }
            }
        });
        Indicator indicator = finished;
        synchronized (indicator) {
            while (true) {
                if (finished.isIndicated()) {
                    return response;
                }
                try {
                    finished.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getServerAnnouncement() {
        return this.serverAnnouncement;
    }

    public Response evaluate(final String input) throws IOException {
        return this.launchParser(new Action(this){

            @Override
            public void run(StreamReceiverClient client) throws IOException {
                client.sendEvaluate(input);
            }
        }, null);
    }

    public void evaluate(final String input, HTMLReceiver htmlReceiver) {
        this.launchParserToHTML(new Action(this){

            @Override
            public void run(StreamReceiverClient client) throws IOException {
                client.sendEvaluate(input);
            }
        }, htmlReceiver);
    }

    private abstract class Action {
        private Action() {
        }

        public abstract void run(StreamReceiverClient var1) throws IOException;
    }

    public static interface CharacterListener {
        public void receive(int var1);
    }

    private class ErrorMessageTrap
    extends InputStreamInterceptor {
        private Snippet errorMessageTrap;

        ErrorMessageTrap(InputStream input) {
            super(input);
            this.errorMessageTrap = new Snippet();
        }

        @Override
        public void interceptedRead(int r) {
            Connection.this.capturedResponseStream(r);
            if (this.errorMessageTrap.isClear()) {
                if (r == 10) {
                    this.errorMessageTrap.create();
                }
            } else {
                this.errorMessageTrap.append(r);
                String possibleErrorStr = this.errorMessageTrap.toString();
                if (possibleErrorStr.length() >= Connection.errorPrefix.length() && !possibleErrorStr.startsWith(Connection.errorPrefix)) {
                    this.errorMessageTrap.clear();
                }
            }
        }

        public String toString() {
            return this.errorMessageTrap.toString();
        }
    }

    public static interface HTMLReceiver {
        public void emitInitialHTML(String var1);

        public void endInitialHTML();

        public void emitProgressiveHTML(String var1);

        public void endProgressiveHTMLRow();
    }

    private static class Indicator {
        boolean indicated = false;

        private Indicator() {
        }

        public void setIndicated(boolean indicated) {
            this.indicated = indicated;
        }

        boolean isIndicated() {
            return this.indicated;
        }
    }

    private static class Snippet {
        private StringBuffer buffer = new StringBuffer();

        private Snippet() {
        }

        public void clear() {
            this.buffer = null;
        }

        public void create() {
            this.buffer = new StringBuffer();
        }

        public boolean isClear() {
            return this.buffer == null;
        }

        public void append(int n) {
            this.buffer.append((char)n);
        }

        public String toString() {
            if (this.buffer == null) {
                return "";
            }
            return this.buffer.toString();
        }
    }
}

