/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client;

import org.reldb.rel.client.InvalidValueException;
import org.reldb.rel.client.Value;
import org.reldb.rel.utilities.StringUtils;

public class Scalar
extends Value {
    private String value = null;
    private boolean quoted = false;

    Scalar(String value, boolean quoted) {
        this.value = value;
        this.quoted = quoted;
    }

    Scalar() {
    }

    @Override
    void addValue(Value value, boolean quoted) {
        this.value = value.toString();
        this.quoted = quoted;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString(int depth) {
        if (this.quoted && depth > 0) {
            return "'" + StringUtils.quote((String)this.value) + "'";
        }
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int toInt() throws InvalidValueException, NumberFormatException {
        return Integer.parseInt(this.value);
    }

    @Override
    public long toLong() throws InvalidValueException, NumberFormatException {
        return Long.parseLong(this.value);
    }

    @Override
    public double toDouble() throws InvalidValueException, NumberFormatException {
        return Double.parseDouble(this.value);
    }

    @Override
    public float toFloat() throws InvalidValueException, NumberFormatException {
        return Float.parseFloat(this.value);
    }

    @Override
    public boolean toBoolean() throws InvalidValueException {
        return Boolean.parseBoolean(this.value);
    }
}

