/*
 * Decompiled with CFR 0.152.
 */
package org.reldb.rel.client;

import java.util.Vector;
import org.reldb.rel.client.InvalidValueException;
import org.reldb.rel.client.Value;

public class Tuple
extends Value {
    private Vector<String> attributeNames = new Vector();
    private Vector<Value> attributeValues = new Vector();

    Tuple() {
    }

    void addAttributeName(String name) {
        this.attributeNames.add(name);
    }

    @Override
    void addValue(Value value, boolean b) {
        this.attributeValues.add(value);
    }

    public int getAttributeCount() {
        return this.attributeValues.size();
    }

    public String getAttributeName(int i) {
        return this.attributeNames.get(i);
    }

    public Value getAttributeValue(int i) {
        return this.attributeValues.get(i);
    }

    public int getIndexOf(String name) {
        return this.attributeNames.indexOf(name);
    }

    public Value getAttributeValue(String name) {
        int index = this.getIndexOf(name);
        if (index < 0) {
            return null;
        }
        return this.getAttributeValue(index);
    }

    public Value get(int i) {
        return this.getAttributeValue(i);
    }

    public Value get(String name) {
        return this.getAttributeValue(name);
    }

    public boolean isNull() {
        return false;
    }

    @Override
    public int toInt() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuple can't be cast to int.");
    }

    @Override
    public long toLong() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuple can't be cast to long.");
    }

    @Override
    public double toDouble() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuple can't be cast to double.");
    }

    @Override
    public float toFloat() throws InvalidValueException, NumberFormatException {
        throw new InvalidValueException("Tuple can't be cast to float.");
    }

    @Override
    public boolean toBoolean() throws InvalidValueException {
        throw new InvalidValueException("Tuple can't be cast to boolean.");
    }

    @Override
    public String toString(int depth) {
        String tuples = "";
        int i = 0;
        while (i < this.getAttributeCount()) {
            if (tuples.length() > 0) {
                tuples = String.valueOf(tuples) + ", ";
            }
            tuples = String.valueOf(tuples) + this.getAttributeName(i) + " " + this.getAttributeValue(i).toString(depth + 1);
            ++i;
        }
        return "TUPLE {" + tuples + "}";
    }

    public String toString() {
        return this.toString(0);
    }
}

